/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.block.tile;

import alexanders.mods.auraddons.Auraddons;
import alexanders.mods.auraddons.init.ModConfig;
import alexanders.mods.auraddons.init.ModPackets;
import alexanders.mods.auraddons.net.JumpPacket;
import alexanders.mods.auraddons.net.ParticlePacket;
import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileAutoWrath
extends TileEntity
implements ITickable {
    @Nullable
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue steps = new TimeValues.VariableValue(1.0f);
    public boolean jumping = false;
    private long doDamage = -1L;
    private int cooldown = 200;

    public TileAutoWrath() {
        this.asm = Auraddons.proxy.loadASM(new ResourceLocation("auraddons", "asms/block/block_auto_wrath_steve.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"steps", (Object)this.steps));
    }

    public void startJumping() {
        if (this.asm != null && this.asm.currentState().equals("default")) {
            this.steps.setValue(0.75f);
            this.asm.transition("jumping");
        }
    }

    public void stopJumping() {
        if (this.asm != null && this.asm.currentState().equals("jumping")) {
            this.asm.transition("default");
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.doDamage != -1L && this.doDamage <= this.func_145831_w().func_82737_E()) {
                this.doDamage = -1L;
                int range = 5;
                List mobs = this.func_145831_w().func_72872_a(EntityLiving.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - (double)range, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)range, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)range, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)range));
                BlockPos spot = IAuraChunk.getHighestSpot((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)25, (BlockPos)this.field_174879_c);
                for (EntityLiving mob : mobs) {
                    if (mob.field_70128_L || this.func_145835_a(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v) > (double)(range * range)) continue;
                    IAuraChunk.getAuraChunk((World)this.field_145850_b, (BlockPos)spot).drainAura(spot, ModConfig.aura.autoWrathMobDamageCost);
                    mob.func_70097_a(DamageSource.field_76376_m, 4.0f);
                }
                ModPackets.sendAround(this.func_145831_w(), this.field_174879_c, 32, new ParticlePacket(ParticlePacket.Type.SHOCK_WAVE, this.field_174879_c));
                this.cooldown = 200;
                this.func_70296_d();
            } else if (this.doDamage != -1L) {
                if (this.cooldown > 0) {
                    --this.cooldown;
                } else {
                    this.doDamage = -1L;
                }
                this.func_70296_d();
            } else if ((this.field_145850_b.func_82737_E() + 3L) % 20L == 0L) {
                boolean found = false;
                if (NaturesAuraAPI.TYPE_NETHER.isPresentInWorld(this.field_145850_b)) {
                    BlockPos spot = IAuraChunk.getHighestSpot((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)25, (BlockPos)this.field_174879_c);
                    IAuraChunk.getAuraChunk((World)this.field_145850_b, (BlockPos)spot).drainAura(spot, ModConfig.aura.autoWrathPulseCost);
                    found = true;
                } else {
                    IItemHandler handler;
                    TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a());
                    if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
                        int slotAmount = handler.getSlots();
                        for (int i = 0; i < slotAmount; ++i) {
                            ItemStack stack = handler.getStackInSlot(i);
                            ResourceLocation name = stack.func_77973_b().getRegistryName();
                            if (name == null || !name.equals((Object)new ResourceLocation("naturesaura", "aura_bottle")) || this.getType(stack) != NaturesAuraAPI.TYPE_NETHER || handler.extractItem(i, 1, true).func_190916_E() < 1) continue;
                            handler.extractItem(i, 1, false);
                            ItemStack glass = new ItemStack(Items.field_151069_bo);
                            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)glass, (boolean)false).func_190926_b()) {
                                EntityItem e = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, glass);
                                e.field_70159_w += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * 6.0;
                                e.field_70181_x += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * 6.0;
                                e.field_70179_y += this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0075f * 6.0;
                                this.field_145850_b.func_72838_d((Entity)e);
                            }
                            found = true;
                            break;
                        }
                    }
                }
                if (found) {
                    this.doDamage = this.func_145831_w().func_82737_E() + 20L;
                    if (!this.jumping) {
                        this.jumping = true;
                        ModPackets.sendTracking(this.field_145850_b, this.field_174879_c, new JumpPacket(this.field_174879_c, true));
                    }
                } else {
                    this.jumping = false;
                    ModPackets.sendTracking(this.field_145850_b, this.field_174879_c, new JumpPacket(this.field_174879_c, false));
                }
                this.func_70296_d();
            }
        }
    }

    private IAuraType getType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        String type = stack.func_77978_p().func_74779_i("stored_type");
        if (type.isEmpty()) {
            return NaturesAuraAPI.TYPE_OTHER;
        }
        return (IAuraType)NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(type));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.doDamage = compound.func_74763_f("doDamage");
        this.cooldown = compound.func_74762_e("cooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("doDamage", this.doDamage);
        compound.func_74768_a("cooldown", this.cooldown);
        return compound;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }
}

