/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.block.tile;

import alexanders.mods.auraddons.block.BlockAuraTransporter;
import alexanders.mods.auraddons.init.ModConfig;
import alexanders.mods.auraddons.init.ModPackets;
import alexanders.mods.auraddons.net.ConnectionPacket;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileAuraTransporter
extends TileEntity
implements ITickable {
    @Nullable
    public BlockPos other = null;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readDestination(compound);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeDestination(compound);
        return super.func_189515_b(compound);
    }

    public void func_70296_d() {
        super.func_70296_d();
        ModPackets.sendTracking(this.field_145850_b, this.field_174879_c, new ConnectionPacket(this.field_174879_c, this.other));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.writeDestination(compound);
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        this.readDestination(compound);
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void readDestination(NBTTagCompound compound) {
        if (compound.func_74764_b("destinationPos")) {
            this.other = BlockPos.func_177969_a((long)compound.func_74763_f("destinationPos"));
        }
    }

    private void writeDestination(NBTTagCompound compound) {
        if (this.other != null) {
            compound.func_74772_a("destinationPos", this.other.func_177986_g());
        }
    }

    private void addAura(int amount) {
        BlockPos spot = NaturesAuraAPI.instance().getLowestAuraDrainSpot(this.field_145850_b, this.field_174879_c, ModConfig.aura.auraTransporterStoreRange, this.field_174879_c);
        IAuraChunk chunk = IAuraChunk.getAuraChunk((World)this.field_145850_b, (BlockPos)spot);
        chunk.storeAura(spot, amount);
        System.out.println("Added " + amount + " aura");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 2L && this.other != null && this.field_145850_b.func_175667_e(this.other)) {
            TileEntity dest = this.field_145850_b.func_175625_s(this.other);
            double distance = Math.sqrt(this.other.func_177951_i((Vec3i)this.field_174879_c));
            if (distance <= ModConfig.aura.auraTransporterRange && dest instanceof TileAuraTransporter) {
                if (!this.field_145850_b.field_72995_K && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockAuraTransporter.SENDING)).booleanValue() && !((Boolean)this.field_145850_b.func_180495_p(this.other).func_177229_b((IProperty)BlockAuraTransporter.SENDING)).booleanValue()) {
                    IAuraChunk chunk;
                    BlockPos spot = NaturesAuraAPI.instance().getHighestAuraDrainSpot(this.field_145850_b, this.field_174879_c, ModConfig.aura.auraTransporterDrainRange, this.field_174879_c);
                    int aura = NaturesAuraAPI.instance().getAuraInArea(this.field_145850_b, spot, 0);
                    if (aura >= ModConfig.aura.auraTransporterAuraAmount + 1000000 && (chunk = IAuraChunk.getAuraChunk((World)this.field_145850_b, (BlockPos)spot)).drainAura(spot, ModConfig.aura.auraTransporterAuraAmount, true, true) >= ModConfig.aura.auraTransporterAuraAmount) {
                        chunk.drainAura(spot, ModConfig.aura.auraTransporterAuraAmount, true, false);
                        ((TileAuraTransporter)dest).addAura(MathHelper.func_76140_b((double)((double)ModConfig.aura.auraTransporterAuraAmount * Math.pow(ModConfig.aura.auraTransporterAuraMultiplierPerBlock, distance))));
                    }
                }
            } else {
                this.other = null;
                this.func_70296_d();
            }
        }
    }
}

