/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.block;

import alexanders.mods.auraddons.block.BlockBase;
import alexanders.mods.auraddons.block.tile.TileAuraTransporter;
import alexanders.mods.auraddons.init.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAuraTransporter
extends BlockBase
implements ITileEntityProvider,
IVisualizable {
    public static PropertyBool SENDING = PropertyBool.func_177716_a((String)"sending");

    public BlockAuraTransporter() {
        super("block_aura_transporter", Material.field_151576_e);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return meta > 0 ? this.func_176223_P().func_177226_a((IProperty)SENDING, (Comparable)Boolean.valueOf(true)) : this.func_176223_P().func_177226_a((IProperty)SENDING, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SENDING) != false ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        block5: {
            BlockPos other;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileAuraTransporter) || (other = ((TileAuraTransporter)te).other) == null || !world.func_175667_e(other)) break block5;
            IBlockState otherState = world.func_180495_p(other);
            boolean thisMode = (Boolean)stateIn.func_177229_b((IProperty)SENDING);
            if (otherState.func_177230_c() == this && thisMode != (Boolean)otherState.func_177229_b((IProperty)SENDING)) {
                if (thisMode) {
                    for (int i = 0; i < 5; ++i) {
                        NaturesAuraAPI.instance().spawnParticleStream((float)pos.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, (float)other.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)other.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)other.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, 0.65f, 13382679, 1.0f);
                    }
                } else {
                    for (int i = 0; i < 5; ++i) {
                        NaturesAuraAPI.instance().spawnParticleStream((float)other.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)other.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)other.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177958_n() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.func_177952_p() + 0.25f + rand.nextFloat() * 0.5f, 0.65f, 13382679, 1.0f);
                    }
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateRedstoneState(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateRedstoneState(worldIn, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAuraTransporter) {
            if (!world.field_72995_K) {
                NBTTagCompound compound = player.getEntityData();
                if (!player.func_70093_af() && compound.func_74764_b("auraddons__aura_transporter_pos")) {
                    BlockPos selectedPos = BlockPos.func_177969_a((long)compound.func_74763_f("auraddons__aura_transporter_pos"));
                    if (selectedPos.equals((Object)pos)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("info.auraddons.same_position", new Object[0]), true);
                    } else if (pos.func_177951_i((Vec3i)selectedPos) < ModConfig.aura.auraTransporterRange * ModConfig.aura.auraTransporterRange || !world.func_175667_e(selectedPos)) {
                        TileEntity other = world.func_175625_s(selectedPos);
                        if (other instanceof TileAuraTransporter) {
                            ((TileAuraTransporter)tile).other = selectedPos;
                            ((TileAuraTransporter)other).other = pos;
                            tile.func_70296_d();
                            other.func_70296_d();
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.auraddons.connected", new Object[0]), true);
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.auraddons.stored_pos_gone", new Object[0]), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("info.auraddons.too_far", new Object[0]), true);
                    }
                } else {
                    compound.func_74772_a("auraddons__aura_transporter_pos", pos.func_177986_g());
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("info.auraddons.stored_pos", new Object[0]), true);
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SENDING});
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileAuraTransporter();
    }

    private void updateRedstoneState(@Nonnull World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)SENDING, (Comparable)Boolean.valueOf(world.func_175687_A(pos) > 0)));
        }
    }

    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(ModConfig.aura.auraTransporterRange);
    }

    public int getVisualizationColor(World world, BlockPos pos) {
        return 3851775;
    }
}

