/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons.aura;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockNetherBrick;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class NetherDegradeEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("auraddons", "nether_degrade_effect");

    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        int dist;
        int amount;
        int aura;
        if (spot < 0 && (aura = IAuraChunk.getAuraInArea((World)world, (BlockPos)pos, (int)25)) < 0 && (amount = Math.min(30000, Math.abs(aura) / 100000)) > 1 && (dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 75000), (int)5, (int)45)) > 0) {
            for (int i = amount / 2 + world.field_73012_v.nextInt(amount / 2); i >= 0; --i) {
                BlockPos blockPos = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)dist, (double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)dist, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)dist);
                if (!(blockPos.func_177951_i((Vec3i)pos) <= (double)(dist * dist)) || !world.func_175667_e(blockPos)) continue;
                IBlockState state = world.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                IBlockState newState = null;
                if (block instanceof BlockNetherrack) {
                    newState = Blocks.field_150425_aM.func_176223_P();
                } else if (block instanceof BlockNetherBrick) {
                    newState = Blocks.field_150424_aL.func_176223_P();
                } else if (block instanceof BlockOre) {
                    newState = Blocks.field_150385_bj.func_176223_P();
                } else if (block instanceof BlockGlowstone) {
                    newState = Blocks.field_150449_bY.func_176223_P();
                }
                if (newState == null) continue;
                world.func_175656_a(blockPos, newState);
            }
        }
    }

    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return type == NaturesAuraAPI.TYPE_NETHER;
    }

    public ResourceLocation getName() {
        return NAME;
    }
}

