/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons;

import alexanders.mods.auraddons.Auraddons;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AltarRecipe;
import net.minecraft.block.BlockPlanks;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorAltarSpecial
implements IComponentProcessor {
    private Ingredient input = Ingredient.field_193370_a;
    private Ingredient output = Ingredient.field_193370_a;
    private Ingredient catalyst = Ingredient.field_193370_a;
    private String name = null;

    public void setup(IVariableProvider<String> provider) {
        String suffix;
        String recipeName = (String)provider.get("recipe");
        switch (suffix = (String)provider.get("suffix")) {
            case "color": {
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName + "_" + color.func_176610_l())));
                }
                break;
            }
            case "wood": {
                for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
                    this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName + "_" + type.func_176610_l())));
                }
                this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName + "_ancient_log")));
                this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName + "_ancient_bark")));
                break;
            }
            default: {
                if (suffix.contains(";")) {
                    String[] suffices;
                    for (String suf : suffices = suffix.split(";")) {
                        if (suf.isEmpty()) {
                            this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName)));
                            continue;
                        }
                        this.addRecipe((AltarRecipe)NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(recipeName + "_" + suf)));
                    }
                    break;
                }
                Auraddons.logger.warn("Unknown suffix type: {}", (Object)suffix);
            }
        }
        this.name = recipeName;
    }

    public String process(String key) {
        switch (key) {
            case "input": {
                return PatchouliAPI.instance.serializeIngredient(this.input);
            }
            case "output": {
                return PatchouliAPI.instance.serializeIngredient(this.output);
            }
            case "catalyst": {
                if (this.catalyst != Ingredient.field_193370_a) {
                    return PatchouliAPI.instance.serializeIngredient(this.catalyst);
                }
                return null;
            }
            case "name": {
                return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void addRecipe(AltarRecipe recipe) {
        if (recipe != null) {
            this.input = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ArrayUtils.addAll((Object[])this.input.func_193365_a(), (Object[])recipe.input.func_193365_a())));
            this.output = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ArrayUtils.addAll((Object[])this.output.func_193365_a(), (Object[])new ItemStack[]{recipe.output})));
            this.catalyst = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ArrayUtils.addAll((Object[])this.catalyst.func_193365_a(), (Object[])recipe.catalyst.func_193365_a())));
        }
    }
}

