/*
 * Decompiled with CFR 0.152.
 */
package alexanders.mods.auraddons;

import alexanders.mods.auraddons.BaublesCompat;
import alexanders.mods.auraddons.IProxy;
import alexanders.mods.auraddons.aura.NetherDegradeEffect;
import alexanders.mods.auraddons.init.ModBlocks;
import alexanders.mods.auraddons.init.ModConfig;
import alexanders.mods.auraddons.init.ModItems;
import alexanders.mods.auraddons.init.ModPackets;
import alexanders.mods.auraddons.init.ModRecipes;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="auraddons", name="Auraddons", version="1.7.2", dependencies="after:baubles;required-after:naturesaura;required-after:patchouli;", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="auraddons")
public class Auraddons {
    public static final Logger logger = LogManager.getLogger((String)"Auraddons");
    @Mod.Instance(owner="auraddons")
    public static Auraddons instance;
    @SidedProxy(modId="auraddons", clientSide="alexanders.mods.auraddons.ClientProxy", serverSide="alexanders.mods.auraddons.ServerProxy")
    public static IProxy proxy;
    public boolean baublesLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModBlocks.init();
        ModItems.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        ModPackets.init();
        if (Loader.isModLoaded((String)"baubles")) {
            this.baublesLoaded = true;
            BaublesCompat.init();
            MinecraftForge.EVENT_BUS.register((Object)new BaublesCompat());
        }
        logger.info("Auraddons pre-initialized");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ModConfig.general.enableNetherDegradeEffect) {
            NaturesAuraAPI.DRAIN_SPOT_EFFECTS.put(NetherDegradeEffect.NAME, NetherDegradeEffect::new);
        }
        ModRecipes.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModBlocks.blockRegistry = null;
        ModItems.itemRegistry = null;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        logger.info("Registering blocks...");
        IForgeRegistry registry = event.getRegistry();
        for (Block b : ModBlocks.blockRegistry) {
            registry.register((IForgeRegistryEntry)b);
        }
        logger.info("Registered {} blocks", (Object)ModBlocks.blockRegistry.size());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        logger.info("Registering items...");
        IForgeRegistry registry = event.getRegistry();
        for (Item b : ModItems.itemRegistry) {
            registry.register((IForgeRegistryEntry)b);
        }
        logger.info("Registered {} items", (Object)ModItems.itemRegistry.size());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        for (Item item : ModItems.itemRegistry) {
            proxy.registerItemModel(item, 0, "inventory");
        }
    }
}

