/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.ritual;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalItems;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierHelper;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

@RitualRegister(value="upgrade_remove")
public class RitualModifierRemove
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualModifierRemove() {
        super("ritualUpgradeRemove", 0, 25000, "ritual.bloodmagic.upgradeRemoveRitual");
        this.addBlockRange(CHECK_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        boolean successful;
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor checkRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List itemList = world.func_72872_a(EntityItem.class, checkRange.getAABB(pos));
        boolean modifierRemove = false;
        for (EntityItem entityItem : itemList) {
            StasisModifiable modifiable;
            boolean removedModifier = false;
            ItemStack itemStack = entityItem.func_92059_d();
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IModifiableItem) || (modifiable = StasisModifiable.getModifiableFromStack(itemStack)) == null) continue;
            HashMap modifierMap = (HashMap)modifiable.getModifierMap();
            for (Map.Entry entry : modifierMap.entrySet()) {
                Modifier modifier = (Modifier)((Pair)entry.getValue()).getLeft();
                ModifierTracker tracker = (ModifierTracker)((Pair)entry.getValue()).getRight();
                String modifierKey = (String)entry.getKey();
                ItemStack modifierStack = new ItemStack(RegistrarBloodArsenalItems.MODIFIER_TOME);
                NBTHelper.checkNBT((ItemStack)modifierStack);
                ModifierHelper.setKey(modifierStack, modifierKey);
                ModifierHelper.setLevel(modifierStack, tracker.getLevel());
                ModifierHelper.setReady(modifierStack, tracker.isReadyToUpgrade());
                modifier.writeSpecialNBT(modifierStack, new ItemStack(itemStack.func_77978_p().func_74775_l("itemStack")), tracker.getLevel());
                successful = modifiable.removeModifier(modifier);
                if (!successful) continue;
                modifierRemove = true;
                removedModifier = true;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, modifierStack));
            }
            if (!removedModifier) continue;
            StasisModifiable.setModifiable(itemStack, modifiable, true);
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
        if (modifierRemove) {
            return;
        }
        List playerList = world.func_72872_a(EntityPlayer.class, checkRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            if (!LivingArmour.hasFullSet((EntityPlayer)player)) continue;
            boolean removedUpgrade = false;
            ItemStack chestStack = ((ItemStack[])Iterables.toArray((Iterable)player.func_184193_aE(), ItemStack.class))[2];
            LivingArmour armour = ItemLivingArmour.getLivingArmour((ItemStack)chestStack);
            if (armour == null) continue;
            HashMap upgradeMap = (HashMap)armour.upgradeMap.clone();
            for (Map.Entry entry : upgradeMap.entrySet()) {
                LivingArmourUpgrade upgrade = (LivingArmourUpgrade)entry.getValue();
                String upgradeKey = (String)entry.getKey();
                ItemStack upgradeStack = new ItemStack(RegistrarBloodMagicItems.UPGRADE_TOME);
                ItemHelper.LivingUpgrades.setKey((ItemStack)upgradeStack, (String)upgradeKey);
                ItemHelper.LivingUpgrades.setLevel((ItemStack)upgradeStack, (int)upgrade.getUpgradeLevel());
                successful = armour.removeUpgrade(player, upgrade);
                if (!successful) continue;
                removedUpgrade = true;
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, upgradeStack));
                for (Map.Entry trackerEntry : armour.trackerMap.entrySet()) {
                    StatTracker tracker = (StatTracker)trackerEntry.getValue();
                    if (tracker == null || !tracker.providesUpgrade(upgradeKey)) continue;
                    tracker.resetTracker();
                }
            }
            if (!removedUpgrade) continue;
            ((ItemLivingArmour)chestStack.func_77973_b()).setLivingArmour(chestStack, armour, true);
            ItemLivingArmour.setLivingArmour((ItemStack)chestStack, (LivingArmour)armour);
            armour.recalculateUpgradePoints();
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
    }

    public int getRefreshTime() {
        return 1;
    }

    public int getRefreshCost() {
        return 0;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
    }

    public Ritual getNewCopy() {
        return new RitualModifierRemove();
    }
}

