/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.recipe;

import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierHandler;
import arcaratus.bloodarsenal.recipe.RecipeFilter;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeSanguineInfusion {
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final ItemStack infuse;
    @Nonnull
    private final ImmutableMap<Ingredient, Integer> inputs;
    @Nonnegative
    private final int lpCost;
    private boolean isModifier = false;
    private String modifierKey = "";
    private Modifier modifier = Modifier.EMPTY_MODIFIER;
    private int levelMultiplier = 1;
    private RecipeFilter filter = null;

    @SafeVarargs
    public RecipeSanguineInfusion(@Nonnull ItemStack output, @Nonnegative int lpCost, @Nonnull ItemStack infuse, Pair<Object, Integer> ... inputs) {
        this.output = output.func_77946_l();
        this.infuse = infuse.func_77946_l();
        this.lpCost = lpCost;
        ImmutableMap.Builder inputsToMap = ImmutableMap.builder();
        for (Pair<Object, Integer> pair : inputs) {
            Object o = pair.getLeft();
            Integer i = (Integer)pair.getRight();
            if (o instanceof Item) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)o)}), (Object)i);
                continue;
            }
            if (o instanceof Block) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)o)}), (Object)i);
                continue;
            }
            if (o instanceof ItemStack) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)o).func_77946_l()}), (Object)i);
                continue;
            }
            if (o instanceof String) {
                inputsToMap.put((Object)new OreIngredient((String)o), (Object)i);
                continue;
            }
            if (o instanceof RecipeFilter) {
                this.filter = (RecipeFilter)o;
                continue;
            }
            throw new IllegalArgumentException("Invalid input: " + o);
        }
        this.inputs = inputsToMap.build();
    }

    @SafeVarargs
    public RecipeSanguineInfusion(@Nonnegative int lpCost, @Nonnull String modifierKey, Pair<Object, Integer> ... inputs) {
        this.output = this.infuse = ItemStack.field_190927_a;
        this.lpCost = lpCost;
        this.isModifier = true;
        this.modifierKey = modifierKey;
        this.modifier = ModifierHandler.getModifierFromKey("bloodarsenal.modifier." + modifierKey);
        ImmutableMap.Builder inputsToMap = ImmutableMap.builder();
        for (Pair<Object, Integer> pair : inputs) {
            Object o = pair.getLeft();
            Integer i = (Integer)pair.getRight();
            if (o instanceof Item) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)o)}), (Object)i);
                continue;
            }
            if (o instanceof Block) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)o)}), (Object)i);
                continue;
            }
            if (o instanceof ItemStack) {
                inputsToMap.put((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)o).func_77946_l()}), (Object)i);
                continue;
            }
            if (o instanceof String) {
                inputsToMap.put((Object)new OreIngredient((String)o), (Object)i);
                continue;
            }
            if (o instanceof RecipeFilter) {
                this.filter = (RecipeFilter)o;
                continue;
            }
            throw new IllegalArgumentException("Invalid input");
        }
        this.inputs = inputsToMap.build();
    }

    public RecipeSanguineInfusion setLevelMultiplier(int levelMultiplier) {
        this.levelMultiplier = levelMultiplier;
        return this;
    }

    public ItemStack getInfuse() {
        return this.infuse;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getLpCost() {
        return this.lpCost;
    }

    public boolean isModifier() {
        return this.isModifier;
    }

    public String getModifierKey() {
        return this.modifierKey;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public int getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public RecipeFilter getFilter() {
        return this.filter;
    }

    public ImmutableMap<Ingredient, Integer> getInputs() {
        return this.getInputsForLevel(-1);
    }

    public ImmutableMap<Ingredient, Integer> getInputsForLevel(int modifierLevel) {
        if (modifierLevel <= 0) {
            return this.inputs;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.inputs.entrySet()) {
            builder.put(entry.getKey(), (Object)((Integer)entry.getValue() * (modifierLevel + 1) * this.getLevelMultiplier()));
        }
        return builder.build();
    }

    public List<List<ItemStack>> getItemStackInputs(int modifierLevel) {
        ArrayList<List<ItemStack>> stackSet = new ArrayList<List<ItemStack>>();
        for (Map.Entry entry : this.getInputsForLevel(modifierLevel).entrySet()) {
            ArrayList<ItemStack> actualStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)entry.getKey()).func_193365_a()) {
                actualStacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)((Integer)entry.getValue())));
            }
            stackSet.add(actualStacks);
        }
        return stackSet;
    }

    public boolean matches(ItemStack infuseStack, List<ItemStack> itemStackInputs) {
        return this.matches(infuseStack, itemStackInputs, -1);
    }

    public boolean matches(ItemStack infuseStack, List<ItemStack> itemStackInputs, int modifierLevel) {
        if (!this.infuse.func_190926_b() && !ItemStack.func_179545_c((ItemStack)this.infuse, (ItemStack)infuseStack)) {
            return false;
        }
        List dummyList = itemStackInputs.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        ImmutableMap<Ingredient, Integer> ingredientsMap = this.getInputsForLevel(modifierLevel);
        boolean foundFilter = this.filter == null;
        for (Map.Entry entry : ingredientsMap.entrySet()) {
            boolean foundIngredient = false;
            Iterator iterator = dummyList.iterator();
            while (iterator.hasNext()) {
                ItemStack input = (ItemStack)iterator.next();
                Ingredient ingredient = (Ingredient)entry.getKey();
                if (ingredient.apply(input) && input.func_190916_E() >= (Integer)entry.getValue()) {
                    foundIngredient = true;
                    iterator.remove();
                    break;
                }
                if (foundFilter || !this.filter.matches(input)) continue;
                foundFilter = true;
                iterator.remove();
            }
            if (foundIngredient) continue;
            return false;
        }
        if (!foundFilter) {
            return false;
        }
        for (ItemStack input : dummyList) {
            if (input.func_190926_b()) continue;
            return false;
        }
        return dummyList.isEmpty();
    }

    public boolean matchesWithSpecificity(ItemStack itemStack, ItemStack compareStack) {
        if (!PotionUtils.func_185189_a((ItemStack)itemStack).isEmpty() && !PotionUtils.func_185189_a((ItemStack)compareStack).isEmpty()) {
            Potion comparePotion;
            Potion potion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)itemStack).get(0)).func_188419_a();
            return potion == (comparePotion = ((PotionEffect)PotionUtils.func_185189_a((ItemStack)compareStack).get(0)).func_188419_a()) && (this.filter == null || this.filter.matches(itemStack)) && ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)compareStack);
        }
        return (this.filter == null || this.filter.matches(itemStack)) && ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)compareStack);
    }
}

