/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier;

import arcaratus.bloodarsenal.modifier.EnumModifierType;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class ModifierHandler {
    public static HashMap<String, Pair<Modifier, ModifierTracker>> modifierMap = new HashMap();
    public static Set<Pair<EnumModifierType, Set<Modifier>>> incompatibleModifiersMap = new HashSet<Pair<EnumModifierType, Set<Modifier>>>();
    public static HashMap<String, Integer> modifierMaxLevelMap = new HashMap();

    public static Modifier registerModifier(Modifier modifier, ModifierTracker tracker) {
        modifierMap.put(modifier.getUniqueIdentifier(), (Pair<Modifier, ModifierTracker>)Pair.of((Object)modifier, (Object)tracker));
        modifierMaxLevelMap.put(modifier.getUniqueIdentifier(), modifier.getMaxLevel());
        return modifier;
    }

    public static void registerIncompatibleModifiers(EnumModifierType type, Modifier ... modifiers) {
        HashSet<Modifier> modList = new HashSet<Modifier>();
        for (Modifier modifier : modifiers) {
            modList.add(modifier);
        }
        incompatibleModifiersMap.add((Pair<EnumModifierType, Set<Modifier>>)Pair.of((Object)((Object)type), modList));
    }

    public static Modifier getModifierFromKey(String key) {
        return ModifierHandler.getModifierFromKey(key, null);
    }

    public static Modifier getModifierFromKey(String key, NBTTagCompound tag) {
        Modifier modifier = (Modifier)modifierMap.get(key).getLeft();
        if (tag != null) {
            modifier.readFromNBT(tag);
        }
        return modifier;
    }

    public static ModifierTracker getTrackerFromKey(String key, int level) {
        return ((ModifierTracker)modifierMap.get(key).getRight()).copy(level);
    }

    public static boolean isModifierCompatible(Collection<String> existingModifiers, Modifier modifier) {
        for (Pair<EnumModifierType, Set<Modifier>> pair : incompatibleModifiersMap) {
            if (pair.getKey() != modifier.getType() || ((Set)pair.getValue()).isEmpty() || !((Set)pair.getValue()).contains(modifier)) continue;
            for (Modifier incompatMod : (Set)pair.getValue()) {
                if (modifier.getUniqueIdentifier().equals(incompatMod.getUniqueIdentifier()) || !existingModifiers.contains(incompatMod.getUniqueIdentifier())) continue;
                return false;
            }
        }
        return true;
    }
}

