/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public final class CommandConfigReload
extends CommandBase {
    private final String name;
    private final String clientName;
    private final Class<?> configClass;
    private final ConfigReloader reloader;
    private final boolean isClient;
    private final String successMessage;

    private CommandConfigReload(String name, String clientName, Class<?> configClass, ConfigReloader reloader, Side side, String successMessage) {
        this.name = name;
        this.clientName = clientName;
        this.configClass = configClass;
        this.reloader = reloader;
        this.isClient = side.isClient();
        this.successMessage = successMessage;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.successMessage == null || this.isClient ? "commands." + this.name + ".usage" : "/" + this.name;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean serverSided;
        if (this.reloader != null) {
            this.reloader.reload(ReloadPhase.PRE, (ICommand)this, sender);
        }
        ConfigManager.reloadFromDisk(this.configClass);
        if (this.reloader != null) {
            this.reloader.reload(ReloadPhase.POST, (ICommand)this, sender);
        }
        boolean bl = serverSided = server != null && server.func_71262_S();
        if (this.successMessage != null && serverSided) {
            CommandConfigReload.func_152373_a((ICommandSender)sender, (ICommand)this, (String)this.successMessage, (Object[])new Object[0]);
        } else {
            String actualName = serverSided ? this.name : this.clientName;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands." + actualName + ".success", new Object[0]));
        }
    }

    public int func_82362_a() {
        return this.isClient ? 0 : 4;
    }

    public static CommandConfigReload client(String name, Class<?> configClass) {
        return CommandConfigReload.client(name, configClass, null);
    }

    public static CommandConfigReload client(String name, Class<?> configClass, ConfigReloader reloader) {
        return new CommandConfigReload(name, name, configClass, reloader, Side.CLIENT, null);
    }

    public static CommandConfigReload server(String name, String clientName, Class<?> configClass) {
        return CommandConfigReload.server(name, clientName, configClass, null, null);
    }

    public static CommandConfigReload server(String name, String clientName, Class<?> configClass, String successMessage) {
        return CommandConfigReload.server(name, clientName, configClass, successMessage, null);
    }

    public static CommandConfigReload server(String name, String clientName, Class<?> configClass, String successMessage, ConfigReloader reloader) {
        return new CommandConfigReload(name, clientName, configClass, reloader, Side.SERVER, successMessage);
    }

    @FunctionalInterface
    public static interface ConfigReloader {
        public void reload(ReloadPhase var1, ICommand var2, ICommandSender var3);
    }

    public static enum ReloadPhase {
        PRE,
        POST;

    }
}

