/*
 * Decompiled with CFR 0.152.
 */
package wolforce.vaultopic.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import wolforce.vaultopic.Vaultopic;

public class VTRecipe
implements IMessage {
    public ItemStack[][] items;
    public boolean maxTransfer;

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.maxTransfer);
        for (ItemStack[] stacks : this.items) {
            if (stacks == null) {
                buf.writeInt(0);
                continue;
            }
            buf.writeInt(stacks.length);
            for (ItemStack s : stacks) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)s);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.maxTransfer = buf.readBoolean();
        this.items = new ItemStack[9][];
        int i = 0;
        while (buf.readableBytes() > 0) {
            int length = buf.readInt();
            if (length == 0) {
                this.items[i] = null;
            } else {
                this.items[i] = new ItemStack[length];
                for (int j = 0; j < length; ++j) {
                    this.items[i][j] = ByteBufUtils.readItemStack((ByteBuf)buf);
                }
            }
            ++i;
        }
    }

    public static class VTRecipeHandler
    implements IMessageHandler<VTRecipe, IMessage> {
        public IMessage onMessage(VTRecipe message, MessageContext ctx) {
            Vaultopic.onRecipe(message, ctx);
            return null;
        }
    }
}

