/*
 * Decompiled with CFR 0.152.
 */
package wolforce.vaultopic.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class InvLocRenderer {
    Minecraft mc = Minecraft.func_71410_x();
    private World world;
    private EntityPlayerSP player;
    private Vec3d diffPos;
    private float partialTicks;
    private RenderItem render;
    private float yaw;
    private float pitch;

    public InvLocRenderer(float partialTicks) {
        this.partialTicks = partialTicks;
        this.world = this.mc.field_71441_e;
        this.player = this.mc.field_71439_g;
        this.render = this.mc.func_175599_af();
        this.yaw = -this.mc.func_175598_ae().field_78735_i;
        this.pitch = this.mc.func_175598_ae().field_78732_j;
    }

    void setLocation(BlockPos location) {
        double px = this.player.field_70142_S + (this.player.field_70165_t - this.player.field_70142_S) * (double)this.partialTicks;
        double py = this.player.field_70137_T + (this.player.field_70163_u - this.player.field_70137_T) * (double)this.partialTicks;
        double pz = this.player.field_70136_U + (this.player.field_70161_v - this.player.field_70136_U) * (double)this.partialTicks;
        this.diffPos = new Vec3d((Vec3i)location).func_178786_a(px, py, pz);
    }

    void renderInventory(ItemStack[] stacks) {
        float x = (float)this.diffPos.field_72450_a + 0.5f;
        float y = (float)this.diffPos.field_72448_b + 0.5f;
        float z = (float)this.diffPos.field_72449_c + 0.5f;
        double scale = stacks.length < 4 ? 0.5 : (stacks.length < 9 ? 0.25 : 0.175);
        this.renderStack(null);
        int xx = 0;
        int yy = 0;
        int w = (int)Math.ceil(Math.sqrt(stacks.length));
        for (ItemStack stack : stacks) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)(-(w / 2) + xx), (float)(-(w / 2) + yy), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)0.0f);
            this.renderStack(stack);
            GlStateManager.func_179121_F();
            if (++xx != w) continue;
            xx = 0;
            ++yy;
        }
    }

    private void renderStack(ItemStack stack) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_179103_j((int)7424);
        if (stack != null) {
            this.render.func_181564_a(stack, ItemCameraTransforms.TransformType.GUI);
        }
        GlStateManager.func_179099_b();
    }
}

