/*
 * Decompiled with CFR 0.152.
 */
package wolforce.vaultopic;

import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wolforce.vaultopic.ContainerVICE;
import wolforce.vaultopic.ItemVIEW;
import wolforce.vaultopic.Searcher;
import wolforce.vaultopic.VaultMain;
import wolforce.vaultopic.VaultUtil;
import wolforce.vaultopic.client.VaultopicClientEvents;
import wolforce.vaultopic.net.MessageType;
import wolforce.vaultopic.net.VTDeliver;
import wolforce.vaultopic.net.VTRecipe;
import wolforce.vaultopic.net.VTRequest;
import wolforce.vaultopic.proxies.Proxy;

@Mod(modid="vaultopic", name="Vaultopic", version="0.3", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="vaultopic")
public class Vaultopic {
    @Mod.Instance(value="vaultopic")
    public static Vaultopic instance;
    @SidedProxy(serverSide="wolforce.vaultopic.proxies.ProxyServer", clientSide="wolforce.vaultopic.proxies.ProxyClient")
    public static Proxy proxy;
    public static final String MODID = "vaultopic";
    public static final String NAME = "Vaultopic";
    public static final String VERSION = "0.3";
    public static final Logger logger;
    public static final SimpleNetworkWrapper NET;
    public static final int VICE = 1;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        VaultMain.preInit(event);
        proxy.pre(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.post(event);
        NET.registerMessage(VTRequest.VTRequestHandler.class, VTRequest.class, MessageType.REQUEST.ordinal(), Side.SERVER);
        NET.registerMessage(VTDeliver.VTDeliverHandler.class, VTDeliver.class, MessageType.DELIVER.ordinal(), Side.CLIENT);
        NET.registerMessage(VTRecipe.VTRecipeHandler.class, VTRecipe.class, MessageType.RECIPE.ordinal(), Side.SERVER);
    }

    public static void onRequest(VTRequest message, MessageContext ctx) {
        EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
        String filterText = message.filterText;
        serverPlayer.func_71121_q().func_152344_a(() -> Searcher.searchAndSend(serverPlayer, filterText, Vaultopic.getRange(ctx.getServerHandler().field_147369_b)));
    }

    private static int getRange(EntityPlayerMP player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemVIEW) {
            return ((ItemVIEW)player.func_184614_ca().func_77973_b()).range;
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemVIEW) {
            return ((ItemVIEW)player.func_184592_cb().func_77973_b()).range;
        }
        return 5;
    }

    public static void onDeliver(VTDeliver message, MessageContext ctx) {
        VaultopicClientEvents.InvPos inv = message.inv;
        VaultopicClientEvents.add(inv);
    }

    public static void onRecipe(VTRecipe message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player.field_71070_bA instanceof ContainerVICE) {
            Vaultopic.recipeGrab(false, (ContainerVICE)player.field_71070_bA, message.items, (EntityPlayer)player, message.maxTransfer);
        }
    }

    public static void recipeGrab(boolean isRemote, ContainerVICE container, ItemStack[][] requested, EntityPlayer player, boolean takeMax) {
        int i;
        if (requested == null) {
            return;
        }
        World world = player.func_130014_f_();
        LinkedList<ItemStack> limbo = new LinkedList<ItemStack>();
        for (i = 0; i < 9; ++i) {
            ItemStack stack;
            if (!VaultUtil.isValid(container.field_75162_e.func_70301_a(i)) || player.field_71071_by.func_70441_a(stack = container.field_75162_e.func_70304_b(i)) || isRemote) continue;
            limbo.add(stack);
        }
        if (!isRemote) {
            for (i = 0; i < requested.length; ++i) {
                if (requested[i] == null) continue;
                ItemStack fromLimbo = Vaultopic.tryGetFromLimbo(requested[i], limbo);
                if (VaultUtil.isValid(fromLimbo)) {
                    container.field_75162_e.func_70299_a(i, fromLimbo);
                    continue;
                }
                ItemStack stack = Searcher.getFromInv(player, requested[i]);
                if (!VaultUtil.isValid(stack)) continue;
                container.field_75162_e.func_70299_a(i, stack);
            }
            if (!Vaultopic.isComplete(requested, container.field_75162_e)) {
                LinkedList<Searcher.FoundStack> foundItems = new LinkedList<Searcher.FoundStack>();
                Searcher.searchNearbyInvs(world, player.func_180425_c(), player, VaultMain.vice.range, takeMax, requested, foundItems);
                for (int i2 = 0; i2 < 9; ++i2) {
                    ItemStack got;
                    if (requested[i2] == null || VaultUtil.isValid(container.field_75162_e.func_70301_a(i2)) || !VaultUtil.isValid(got = Vaultopic.getOneFromFound(requested[i2], foundItems))) continue;
                    container.field_75162_e.func_70299_a(i2, got);
                }
            }
        }
        for (ItemStack stack : limbo) {
            VaultUtil.spawnItem(world, player.func_180425_c(), stack, new double[0]);
        }
    }

    private static boolean isComplete(ItemStack[][] requested, InventoryCrafting craftMatrix) {
        for (int i = 0; i < requested.length; ++i) {
            ItemStack stack;
            if (requested[i] == null || Vaultopic.isAny(stack = craftMatrix.func_70301_a(i), requested[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(ItemStack testStack, ItemStack[] ingredient) {
        for (ItemStack itemStack : ingredient) {
            if (!VaultUtil.equalExceptAmount(testStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack getOneFromFound(ItemStack[] requested, LinkedList<Searcher.FoundStack> foundItems) {
        for (ItemStack requestedStack : requested) {
            for (Searcher.FoundStack foundStack : foundItems) {
                ItemStack stack = foundStack.handler.getStackInSlot(foundStack.index);
                if (!VaultUtil.equalExceptAmount(requestedStack, stack) || !VaultUtil.isValid(stack)) continue;
                return foundStack.handler.extractItem(foundStack.index, 1, false);
            }
        }
        return null;
    }

    private static ItemStack tryGetFromLimbo(ItemStack[] requested, LinkedList<ItemStack> limbo) {
        for (ItemStack stackRequested : requested) {
            for (ItemStack stackLimbo : limbo) {
                if (!VaultUtil.isValid(stackRequested) || !VaultUtil.isValid(stackLimbo) || !VaultUtil.equalExceptAmount(stackLimbo, stackRequested)) continue;
                ItemStack ret = stackLimbo.func_77946_l();
                ret.func_190920_e(1);
                stackLimbo.func_190918_g(1);
                return ret;
            }
        }
        return null;
    }

    static {
        logger = LogManager.getLogger((String)NAME);
        NET = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

