/*
 * Decompiled with CFR 0.152.
 */
package wolforce.vaultopic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wolforce.vaultopic.VaultUtil;
import wolforce.vaultopic.Vaultopic;
import wolforce.vaultopic.client.VaultopicClientEvents;
import wolforce.vaultopic.net.VTDeliver;

public class Searcher {
    public static void searchAndSend(EntityPlayerMP player, String filterText, int range) {
        if (filterText.trim().equals("")) {
            return;
        }
        WorldServer world = (WorldServer)player.func_130014_f_();
        HashSet<IItemHandler> set = new HashSet<IItemHandler>();
        for (int x = -range; x < range; ++x) {
            for (int y = -range; y < range; ++y) {
                for (int z = -range; z < range; ++z) {
                    IItemHandler inv;
                    BlockPos pos = new BlockPos(player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z);
                    TileEntity te = world.func_175625_s(pos);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (te == null || (inv = Searcher.getInv(te)) == null || set.contains(inv)) continue;
                    set.add(inv);
                    ArrayList<ItemStack> items = Searcher.searchinv(inv, filterText.trim());
                    if (items.isEmpty()) continue;
                    ItemStack[] array = new ItemStack[items.size()];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = items.get(i);
                    }
                    world.func_152344_a(() -> {
                        VTDeliver message = new VTDeliver();
                        message.inv = new VaultopicClientEvents.InvPos(pos, array);
                        Vaultopic.NET.sendTo((IMessage)message, player);
                    });
                }
            }
        }
    }

    private static ArrayList<ItemStack> searchinv(IItemHandler inv, String filterText) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!VaultUtil.isValid(stack) || !Searcher.isValid(stack, filterText.toLowerCase())) continue;
            items.add(stack);
        }
        return items;
    }

    private static boolean isValid(ItemStack stack, String filterText) {
        String[] filters;
        String itemname = stack.func_82833_r().toLowerCase();
        String modname = stack.func_77973_b().getRegistryName().func_110624_b().toLowerCase();
        for (String filter : filters = filterText.split(" ")) {
            if (filter.length() == 0 || !(filter.startsWith("@") ? !modname.contains(filter.substring(1)) : !itemname.contains(filter))) continue;
            return false;
        }
        return true;
    }

    private static IItemHandler getInv(TileEntity te) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        }
        return null;
    }

    public static void searchNearbyInvs(World world, BlockPos _pos, EntityPlayer player, int range, boolean takeMax, ItemStack[][] ingredients, LinkedList<FoundStack> foundItems) {
        if (world == null || _pos == null || player == null || ingredients == null) {
            return;
        }
        for (int x = -range; x < range; ++x) {
            for (int y = -range; y < range; ++y) {
                for (int z = -range; z < range; ++z) {
                    IItemHandler inv;
                    Block block;
                    BlockPos pos = _pos.func_177982_a(x, y, z);
                    TileEntity te = world.func_175625_s(pos);
                    if (te == null || world.func_180495_p(pos) == null || (block = world.func_180495_p(pos).func_177230_c()) == null || (inv = Searcher.getInv(te)) == null) continue;
                    LinkedList<Integer> indexes = Searcher.searchInv(inv, ingredients, takeMax);
                    Iterator iterator = indexes.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        if (index < 0 || index >= inv.getSlots() || !VaultUtil.isValid(inv.getStackInSlot(index))) continue;
                        foundItems.add(new FoundStack(inv, index));
                    }
                }
            }
        }
    }

    private static LinkedList<Integer> searchInv(IItemHandler inv, ItemStack[][] ingredients, boolean takeMax) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!Searcher.searchInvSlot(inv, i, ingredients, takeMax)) continue;
            indexes.add(i);
        }
        return indexes;
    }

    private static boolean searchInvSlot(IItemHandler inv, int i, ItemStack[][] ingredients, boolean takeMax) {
        ItemStack stack = inv.getStackInSlot(i);
        for (ItemStack[] ingredient : ingredients) {
            if (ingredient == null) continue;
            for (ItemStack ingredientStack : ingredient) {
                if (ingredientStack == null || !VaultUtil.isValid(stack) || !VaultUtil.equalExceptAmount(stack, ingredientStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFromInv(EntityPlayer player, ItemStack[] ingredient) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!VaultUtil.isValid(stack)) continue;
            for (ItemStack requestedStack : ingredient) {
                if (requestedStack == null || !VaultUtil.equalExceptAmount(stack, requestedStack)) continue;
                return player.field_71071_by.func_70298_a(i, 1);
            }
        }
        return null;
    }

    public static class FoundStack {
        public IItemHandler handler;
        public int index;

        public FoundStack(IItemHandler handler, int index) {
            this.handler = handler;
            this.index = index;
        }
    }
}

