/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.color;

import java.util.ArrayList;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class ColorUtil {
    private static final String[] defDyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};

    public static boolean isDye(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> ores = new ArrayList<String>();
        for (int id : oreIDs) {
            ores.add(OreDictionary.getOreName((int)id));
        }
        for (String dye : defDyeNames) {
            if (!ores.contains("dye" + dye)) continue;
            return true;
        }
        return false;
    }

    public static EnumDyeColor getDyeColor(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> ores = new ArrayList<String>();
        for (int id : oreIDs) {
            ores.add(OreDictionary.getOreName((int)id));
        }
        int meta = 0;
        for (String dye : defDyeNames) {
            if (ores.contains("dye" + dye)) {
                return EnumDyeColor.func_176764_b((int)(15 - meta));
            }
            ++meta;
        }
        return null;
    }

    public static int getDyeColorInt(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> ores = new ArrayList<String>();
        for (int id : oreIDs) {
            ores.add(OreDictionary.getOreName((int)id));
        }
        int meta = 0;
        for (String dye : defDyeNames) {
            if (ores.contains("dye" + dye)) {
                return ItemDye.field_150922_c[meta];
            }
            ++meta;
        }
        return 0xFFFFFF;
    }

    public static String format(String src) {
        for (TextFormatting f : TextFormatting.values()) {
            String s = f.toString();
            src = src.replaceAll("&" + s.substring(1), s);
        }
        return src;
    }

    public static float[] reverse(float ... rgb) {
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = 1.0f - rgb[i];
        }
        return rgb;
    }

    public static float[] checkHandReverse(EnumHand hand, float ... rgb) {
        return hand == EnumHand.MAIN_HAND ? rgb : ColorUtil.reverse(rgb);
    }
}

