/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.utils.InterItemStack;
import com.zeitheron.hammercore.utils.InventoryUtils;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackUtil {
    public static ItemStack cycleItemStack(Object input) {
        NonNullList q;
        ItemStack it = ItemStack.field_190927_a;
        if (input instanceof ItemStack) {
            it = (ItemStack)input;
            if (it.func_77960_j() == Short.MAX_VALUE && it.func_77973_b().func_77614_k()) {
                NonNullList q2 = NonNullList.func_191196_a();
                it.func_77973_b().func_150895_a(it.func_77973_b().func_77640_w(), q2);
                if (q2 != null && q2.size() > 0) {
                    int md = (int)(System.currentTimeMillis() / 1000L % (long)q2.size());
                    ItemStack it2 = new ItemStack(it.func_77973_b(), 1, md);
                    it2.func_77982_d(it.func_77978_p());
                    it = it2;
                }
            } else if (it.func_77960_j() == Short.MAX_VALUE && it.func_77984_f()) {
                int md = (int)(System.currentTimeMillis() / 10L % (long)it.func_77958_k());
                ItemStack it2 = new ItemStack(it.func_77973_b(), 1, md);
                it2.func_77982_d(it.func_77978_p());
                it = it2;
            }
            if (it.func_77960_j() != 0 && !it.func_77981_g() && !it.func_77984_f()) {
                it.func_77964_b(0);
            }
        } else if (input instanceof ItemStack[]) {
            ItemStack[] q3 = (ItemStack[])input;
            if (q3 != null && q3.length > 0) {
                int idx = (int)(System.currentTimeMillis() / 1000L % (long)q3.length);
                it = InventoryUtils.cycleItemStack(q3[idx]);
            }
        } else if (input instanceof Ingredient) {
            it = InventoryUtils.cycleItemStack(((Ingredient)input).func_193365_a());
        } else if (input instanceof List) {
            List q3 = (List)input;
            if (q3 != null && q3.size() > 0) {
                int idx = (int)(System.currentTimeMillis() / 1000L % (long)q3.size());
                it = InventoryUtils.cycleItemStack(q3.get(idx));
            }
        } else if (input instanceof String && !(q = OreDictionary.getOres((String)(input + ""))).isEmpty()) {
            int idx = (int)(System.currentTimeMillis() / 1000L % (long)q.size());
            it = InventoryUtils.cycleItemStack(q.get(idx));
        }
        return it;
    }

    public static ItemStack compact(IInventory inv, ItemStack stack, IntList founds) {
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).func_77969_a(stack)) continue;
            int j = inv.func_70301_a(i).func_190916_E();
            count += j;
            founds.add(i);
        }
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(count);
        return st;
    }

    public static boolean tagsEqual(NBTTagCompound a, NBTTagCompound b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals((Object)b);
    }

    public static boolean itemsEqual(ItemStack a, ItemStack b) {
        if (("" + a).equals("" + b)) {
            return true;
        }
        if (InterItemStack.isStackNull(a) || InterItemStack.isStackNull(b)) {
            return false;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i() && ItemStackUtil.tagsEqual(a.func_77978_p(), b.func_77978_p());
    }

    public static boolean contains(ItemStack[] stacks, ItemStack stack) {
        stacks = Arrays.copyOf(stacks, stacks.length);
        stack = stack.func_77946_l();
        for (ItemStack s : stacks) {
            if (!ItemStackUtil.itemsEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static void dropStack(ItemStack stack, World world, BlockPos pos) {
        Random rand = world.field_73012_v;
        if (!stack.func_190926_b() && !world.field_72995_K) {
            AxisAlignedBB aabb = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos);
            if (aabb == null) {
                aabb = new AxisAlignedBB(pos);
            }
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + (aabb.field_72336_d - aabb.field_72338_b) / 2.0, (double)pos.func_177956_o() + aabb.field_72337_e, (double)pos.func_177952_p() + (aabb.field_72334_f - aabb.field_72339_c) / 2.0, stack.func_77946_l());
            ei.field_70159_w = (rand.nextDouble() - rand.nextDouble()) * 0.045;
            ei.field_70181_x = rand.nextDouble() * 0.25;
            ei.field_70179_y = (rand.nextDouble() - rand.nextDouble()) * 0.045;
            world.func_72838_d((Entity)ei);
        }
    }

    public static void ejectOrDrop(ItemStack stack, TileEntity from) {
        if (stack.func_190926_b()) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntity tile = from.func_145831_w().func_175625_s(from.func_174877_v().func_177972_a(face));
            if ((stack = ItemStackUtil.inject(stack, tile, face.func_176734_d())).func_190926_b()) break;
        }
        if (!stack.func_190926_b()) {
            ItemStackUtil.dropStack(stack, from.func_145831_w(), from.func_174877_v());
        }
    }

    public static ItemStack inject(ItemStack item, TileEntity tile, EnumFacing capFace) {
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, capFace) ? ItemStackUtil.inject(item, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, capFace)) : item;
    }

    public static ItemStack inject(ItemStack item, IItemHandler h) {
        for (int i = 0; h != null && i < h.getSlots() && !item.func_190926_b(); ++i) {
            if (item.func_190926_b()) continue;
            item = h.insertItem(i, item, false);
        }
        return item;
    }

    public static void splitOrDropItemAround(ItemStack stack, World w, BlockPos from, ItemDropData data, EnumFacing ... blackist) {
        if (ItemStackUtil.shouldReturn(stack = ItemStackUtil.splitItemAround(stack, w, from, blackist))) {
            return;
        }
        EntityItem i = new EntityItem(w, (double)from.func_177958_n() + 0.5, (double)(from.func_177956_o() + 1), (double)from.func_177952_p() + 0.5, stack);
        i.func_70016_h(0.0, 0.0, 0.0);
        i.field_70173_aa = -data.despawnTime;
        if (data.pickupDelayMode == 0) {
            i.func_174871_r();
        } else if (data.pickupDelayMode == 2) {
            i.func_174868_q();
        }
        w.func_72838_d((Entity)i);
    }

    public static ItemStack splitItemAround(ItemStack stack, World w, BlockPos from, EnumFacing ... blackist) {
        if (w.field_72995_K) {
            return stack;
        }
        List<EnumFacing> b = Arrays.asList(blackist);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (b.contains(f)) continue;
            TileEntity entity = w.func_175625_s(from.func_177972_a(f));
            if (entity instanceof IInventory) {
                ISidedInventory i;
                if (entity instanceof ISidedInventory) {
                    i = (ISidedInventory)entity;
                    stack = ItemStackUtil.insertSided(i, stack, f.func_176734_d());
                } else {
                    i = (IInventory)entity;
                    stack = ItemStackUtil.insert((IInventory)i, stack);
                }
            }
            if (!ItemStackUtil.shouldReturn(stack)) continue;
            return null;
        }
        return stack;
    }

    public static ItemStack insert(IInventory to, ItemStack what) {
        for (int i = 0; i < to.func_70302_i_(); ++i) {
            if (!to.func_94041_b(i, what)) continue;
            ItemStack in = to.func_70301_a(i);
            if (in == null) {
                to.func_70299_a(i, what);
                return null;
            }
            if (ItemStackUtil.itemsEqual(what, in) && InterItemStack.getStackSize(in) < in.func_77976_d()) {
                int howM = InterItemStack.getStackSize(what);
                while (howM + InterItemStack.getStackSize(in) > in.func_77976_d()) {
                    --howM;
                }
                InterItemStack.setStackSize(what, InterItemStack.getStackSize(what) - howM);
                InterItemStack.setStackSize(in, InterItemStack.getStackSize(in) + howM);
            }
            if (!ItemStackUtil.shouldReturn(what)) continue;
            return null;
        }
        return what;
    }

    public static ItemStack insertSided(ISidedInventory to, ItemStack what, EnumFacing from) {
        for (int i = 0; i < to.func_70302_i_(); ++i) {
            if (!to.func_180462_a(i, what, from) && !to.func_94041_b(i, what)) continue;
            ItemStack in = to.func_70301_a(i);
            if (in == null) {
                to.func_70299_a(i, what);
                return null;
            }
            if (ItemStackUtil.itemsEqual(what, in) && InterItemStack.getStackSize(in) < in.func_77976_d()) {
                int howM = InterItemStack.getStackSize(what);
                while (howM + InterItemStack.getStackSize(in) > in.func_77976_d()) {
                    --howM;
                }
                InterItemStack.setStackSize(what, InterItemStack.getStackSize(what) - howM);
                InterItemStack.setStackSize(in, InterItemStack.getStackSize(in) + howM);
            }
            if (!ItemStackUtil.shouldReturn(what)) continue;
            return null;
        }
        return what;
    }

    public static boolean shouldReturn(ItemStack stack) {
        return stack == null || InterItemStack.getStackSize(stack) <= 0;
    }

    public static NonNullList<ItemStack> getTopItems(IInventory inv, int count) {
        int i;
        NonNullList top = NonNullList.func_191197_a((int)count, (Object)ItemStack.field_190927_a);
        NonNullList all = NonNullList.func_191196_a();
        InventoryDummy invd = new InventoryDummy(0);
        invd.inventory = all;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i).func_77946_l();
            if (ItemStackUtil.count(item, invd) != 0) continue;
            item.func_190920_e(ItemStackUtil.count(item, inv));
            all.add((Object)item);
        }
        all.sort((a, b) -> ItemStackUtil.count(b, invd) - ItemStackUtil.count(a, invd));
        for (i = 0; i < Math.min(all.size(), count); ++i) {
            top.set(i, all.get(i));
        }
        return top;
    }

    public static int count(ItemStack stack, IInventory stacks) {
        int found = 0;
        for (int i = 0; i < stacks.func_70302_i_(); ++i) {
            if (!stack.func_77969_a(stacks.func_70301_a(i))) continue;
            found += stacks.func_70301_a(i).func_190916_E();
        }
        return found;
    }

    public static final class ItemDropData {
        public int pickupDelayMode = 1;
        public int despawnTime = 6000;

        public ItemDropData(int pickupDelayMode, int despawnTime) {
            this.pickupDelayMode = pickupDelayMode;
            this.despawnTime = despawnTime;
        }
    }
}

