/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.objl;

import com.zeitheron.hammercore.lib.objl.CgrTools;
import com.zeitheron.hammercore.lib.objl.Model;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class OBJLoader {
    private Model model;
    public ArrayList<float[]> vertexsets = new ArrayList();
    public ArrayList<float[]> vertexsetsnorms = new ArrayList();
    public ArrayList<float[]> vertexsetstexs = new ArrayList();
    public ArrayList<int[]> faces = new ArrayList();
    public ArrayList<int[]> facestexs = new ArrayList();
    public ArrayList<int[]> facesnorms = new ArrayList();
    int texA = 0;
    int TEX_MODE = 2;

    public OBJLoader(Model model) {
        this.model = model;
    }

    public void load(BufferedReader br) throws IOException {
        String line;
        int lineCounter = 0;
        block16: while ((line = br.readLine()) != null) {
            String[] splitedLine = line.split(" ");
            ++lineCounter;
            switch (splitedLine[0]) {
                case "v": {
                    float[] vertex = new float[]{Float.parseFloat(splitedLine[1]), Float.parseFloat(splitedLine[2]), Float.parseFloat(splitedLine[3])};
                    if (vertex[0] > this.model.maxX) {
                        this.model.maxX = vertex[0];
                    } else if (vertex[0] < this.model.minX) {
                        this.model.minX = vertex[0];
                    }
                    if (vertex[1] > this.model.maxY) {
                        this.model.maxY = vertex[1];
                    } else if (vertex[1] < this.model.minY) {
                        this.model.minY = vertex[1];
                    }
                    if (vertex[2] > this.model.maxZ) {
                        this.model.maxZ = vertex[2];
                    } else if (vertex[2] < this.model.minZ) {
                        this.model.minZ = vertex[2];
                    }
                    this.vertexsets.add(vertex);
                    continue block16;
                }
                case "vn": {
                    float[] normal = new float[]{Float.parseFloat(splitedLine[1]), Float.parseFloat(splitedLine[2]), Float.parseFloat(splitedLine[3])};
                    this.vertexsetsnorms.add(normal);
                    continue block16;
                }
                case "vt": {
                    float[] texCoord;
                    if (this.TEX_MODE == 1) {
                        texCoord = new float[]{Float.parseFloat(splitedLine[1]), Math.abs((float)this.texA - Float.parseFloat(splitedLine[2]))};
                        this.vertexsetstexs.add(texCoord);
                        continue block16;
                    }
                    texCoord = new float[]{Float.parseFloat(splitedLine[1]), Math.abs((float)this.texA - Float.parseFloat(splitedLine[2])), Float.parseFloat(splitedLine[3])};
                    this.vertexsetstexs.add(texCoord);
                    continue block16;
                }
                case "f": {
                    int[] fv = new int[splitedLine.length - 1];
                    int[] ft = new int[splitedLine.length - 1];
                    int[] fn = new int[splitedLine.length - 1];
                    for (int i = 1; i < splitedLine.length; ++i) {
                        String[] pos = splitedLine[i].split("/");
                        if (pos.length == 1) {
                            fv[i - 1] = Integer.parseInt(pos[0]);
                            continue;
                        }
                        if (pos.length == 2) {
                            fv[i - 1] = Integer.parseInt(pos[0]);
                            ft[i - 1] = Integer.parseInt(pos[1]);
                            continue;
                        }
                        if (pos.length != 3) continue;
                        fv[i - 1] = Integer.parseInt(pos[0]);
                        if (!pos[1].equals("")) {
                            ft[i - 1] = Integer.parseInt(pos[1]);
                        }
                        fn[i - 1] = Integer.parseInt(pos[2]);
                    }
                    this.faces.add(fv);
                    this.facestexs.add(ft);
                    this.facesnorms.add(fn);
                    continue block16;
                }
                case "#": {
                    continue block16;
                }
                case "o": {
                    System.out.println("Loading " + splitedLine[1]);
                    continue block16;
                }
            }
            System.out.println("Unsupported command " + splitedLine[0] + " on line " + lineCounter);
        }
    }

    public void convertToArrays(boolean isMakeNormalsArray, boolean isMakeTexCoordsArray) {
        int i;
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> textures = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        ArrayList<Model.VerticesDescriptor> vertd = new ArrayList<Model.VerticesDescriptor>();
        int counter = 0;
        for (i = 0; i < this.faces.size(); ++i) {
            int[] tempfaces = this.faces.get(i);
            int[] tempfacesnorms = this.facesnorms.get(i);
            int[] tempfacestexs = this.facestexs.get(i);
            if (vertd.size() == 0) {
                vertd.add(new Model.VerticesDescriptor());
            }
            if (tempfaces.length == 3) {
                if (((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE == this.model.POLY_TYPE_TRIANGLES || ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE == -1) {
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).END += 3;
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE = this.model.POLY_TYPE_TRIANGLES;
                } else {
                    Model.VerticesDescriptor nvd = new Model.VerticesDescriptor();
                    nvd.START = counter;
                    nvd.END += 3;
                    nvd.POLYTYPE = this.model.POLY_TYPE_TRIANGLES;
                    vertd.add(nvd);
                }
            } else if (tempfaces.length == 4) {
                vertd.get(vertd.size() - 1);
                if (((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE == this.model.POLY_TYPE_QUADS || ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE == -1) {
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).END += 4;
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE = this.model.POLY_TYPE_QUADS;
                } else {
                    Model.VerticesDescriptor nvd = new Model.VerticesDescriptor();
                    nvd.START = counter;
                    nvd.END += 4;
                    nvd.POLYTYPE = this.model.POLY_TYPE_QUADS;
                    vertd.add(nvd);
                }
            } else {
                vertd.get(vertd.size() - 1);
                if (((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE == -1) {
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).END += tempfaces.length;
                    ((Model.VerticesDescriptor)vertd.get((int)(vertd.size() - 1))).POLYTYPE = this.model.POLY_TYPE_POLYGON;
                } else {
                    Model.VerticesDescriptor nvd = new Model.VerticesDescriptor();
                    nvd.START = counter;
                    nvd.END += tempfaces.length;
                    nvd.POLYTYPE = this.model.POLY_TYPE_POLYGON;
                    vertd.add(nvd);
                }
            }
            counter += tempfaces.length;
            for (int w = 0; w < tempfaces.length; ++w) {
                if (isMakeNormalsArray) {
                    if (tempfacesnorms[w] != 0) {
                        normals.add(Float.valueOf(this.vertexsetsnorms.get(tempfacesnorms[w] - 1)[0]));
                        normals.add(Float.valueOf(this.vertexsetsnorms.get(tempfacesnorms[w] - 1)[1]));
                        normals.add(Float.valueOf(this.vertexsetsnorms.get(tempfacesnorms[w] - 1)[2]));
                    } else {
                        normals.add(Float.valueOf(0.0f));
                        normals.add(Float.valueOf(0.0f));
                        normals.add(Float.valueOf(0.0f));
                    }
                }
                if (isMakeTexCoordsArray) {
                    if (tempfacestexs[w] != 0) {
                        textures.add(Float.valueOf(this.vertexsetstexs.get(tempfacestexs[w] - 1)[0]));
                        textures.add(Float.valueOf(this.vertexsetstexs.get(tempfacestexs[w] - 1)[1]));
                        if (this.TEX_MODE == 2) {
                            textures.add(Float.valueOf(this.vertexsetstexs.get(tempfacestexs[w] - 1)[2]));
                        }
                    } else {
                        textures.add(Float.valueOf(0.0f));
                        textures.add(Float.valueOf(0.0f));
                        if (this.TEX_MODE == 2) {
                            textures.add(Float.valueOf(0.0f));
                        }
                    }
                }
                vertices.add(Float.valueOf(this.vertexsets.get(tempfaces[w] - 1)[0]));
                vertices.add(Float.valueOf(this.vertexsets.get(tempfaces[w] - 1)[1]));
                vertices.add(Float.valueOf(this.vertexsets.get(tempfaces[w] - 1)[2]));
            }
        }
        this.model.vertices = CgrTools.convertArrayListToArray(vertices);
        if (isMakeTexCoordsArray) {
            this.model.texCoords = CgrTools.convertArrayListToArray(textures);
        }
        if (isMakeNormalsArray) {
            this.model.normals = CgrTools.convertArrayListToArray(normals);
        }
        this.model.vd = new Model.VerticesDescriptor[vertd.size()];
        for (i = 0; i < vertd.size(); ++i) {
            this.model.vd[i] = (Model.VerticesDescriptor)vertd.get(i);
        }
        vertd.clear();
        vertices.clear();
        textures.clear();
        normals.clear();
    }
}

