/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.bookAPI.fancy;

import com.zeitheron.hammercore.bookAPI.fancy.HCFontRenderer;
import com.zeitheron.hammercore.bookAPI.fancy.ManualCategories;
import com.zeitheron.hammercore.bookAPI.fancy.ManualPage;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.hammercore.utils.web.URLLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ManualEntry {
    public final String key;
    public final String category;
    public int color = 0xFFFFFF;
    public String[] parents = null;
    public String[] siblings = null;
    public final int displayColumn;
    public final int displayRow;
    public final Object icon_item;
    public final ResourceLocation icon_resource;
    private boolean isSpecial;
    private EnumEntryShape shape = EnumEntryShape.SQUARE;
    private ManualPage[] pages = null;

    public ManualEntry(String key, String category) {
        this.key = key;
        this.category = category;
        this.icon_resource = null;
        this.icon_item = null;
        this.displayColumn = 0;
        this.displayRow = 0;
        Random r = new Random((key + category).hashCode());
        float red = 0.25f + r.nextFloat() * 0.75f;
        float green = 0.25f + r.nextFloat() * 0.75f;
        float blue = 0.25f + r.nextFloat() * 0.75f;
        this.setColor(ColorHelper.packRGB(red, green, blue));
    }

    public ManualEntry(String key, String category, int col, int row, ResourceLocation icon) {
        this.key = key;
        this.category = category;
        this.icon_resource = icon;
        this.icon_item = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, ItemStack icon) {
        this.key = key;
        this.category = category;
        this.icon_item = icon;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, URLLocation icon) {
        this.key = key;
        this.category = category;
        this.icon_item = icon;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, ItemStack ... icons) {
        this.key = key;
        this.category = category;
        this.icon_item = icons;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, List<ItemStack> icons) {
        this.key = key;
        this.category = category;
        this.icon_item = icons;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, Ingredient icon) {
        this.key = key;
        this.category = category;
        this.icon_item = icon;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry(String key, String category, int col, int row, String iconOreDict) {
        this.key = key;
        this.category = category;
        this.icon_item = iconOreDict;
        this.icon_resource = null;
        this.displayColumn = col;
        this.displayRow = row;
    }

    public ManualEntry setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public ManualEntry setParents(String ... par) {
        this.parents = par;
        return this;
    }

    public ManualEntry setPages(ManualPage ... par) {
        this.pages = par;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ManualPage[] getPagesWrapped(HCFontRenderer font, int maxWidth, int maxHeight) {
        ArrayList<ManualPage> pages = new ArrayList<ManualPage>();
        for (ManualPage page : this.getPagesRaw()) {
            page.addPage(font, maxWidth, maxHeight, pages);
        }
        return pages.toArray(new ManualPage[pages.size()]);
    }

    public boolean isVisibleTo(EntityPlayer player) {
        return true;
    }

    public ManualPage[] getPagesRaw() {
        return this.pages;
    }

    public ManualEntry registerEntry() {
        ManualCategories.addEntry(this);
        return this;
    }

    public String getName() {
        return I18n.func_135052_a((String)("hc.manual_name." + this.key), (Object[])new Object[0]);
    }

    public String getText() {
        return I18n.func_135052_a((String)("hc.manual_text." + this.key), (Object[])new Object[0]);
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    @Deprecated
    public eEntryShape getShape() {
        return eEntryShape.values()[this.shape.ordinal()];
    }

    @Deprecated
    public ManualEntry setShape(eEntryShape shape) {
        return this.setShape(EnumEntryShape.values()[shape.ordinal()]);
    }

    public ManualEntry setShape(EnumEntryShape shape) {
        this.shape = shape;
        return this;
    }

    public EnumEntryShape getEntryShape() {
        return this.shape;
    }

    public int getColor() {
        return this.color;
    }

    public ManualEntry setColor(int color) {
        this.color = color;
        return this;
    }

    public static enum EnumEntryShape {
        SQUARE,
        ROUND,
        HEX;

    }

    @Deprecated
    public static enum eEntryShape {
        SQUARE,
        ROUND,
        HEX;

    }
}

