/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.util;

import c4.culinaryconstruct.common.util.NBTHelper;
import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.proxy.ClientProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class NutritionHelper {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;

    public static void applyNutrients(EntityPlayer player, ItemStack stack) {
        NonNullList<ItemStack> ingredients = NBTHelper.getIngredientsList(stack, true);
        List<Nutrient> foundNutrients = NutritionHelper.getNutrients(ingredients);
        float nutritionValue = NutrientUtils.calculateNutrition((ItemStack)stack, foundNutrients);
        if (!player.field_70170_p.field_72995_K) {
            INutrientManager manager = (INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null);
            if (manager != null) {
                manager.add(foundNutrients, nutritionValue);
            }
        } else {
            ClientProxy.localNutrition.add(foundNutrients, nutritionValue);
        }
    }

    public static String getNutrientsTooltip(ItemStack stack) {
        NonNullList<ItemStack> ingredients = NBTHelper.getIngredientsList(stack, true);
        List<Nutrient> foundNutrients = NutritionHelper.getNutrients(ingredients);
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (Nutrient nutrient : foundNutrients) {
            if (!nutrient.visible) continue;
            stringJoiner.add(I18n.func_135052_a((String)("nutrient.nutrition:" + nutrient.name), (Object[])new Object[0]));
        }
        String nutrientString = stringJoiner.toString();
        float nutritionValue = NutrientUtils.calculateNutrition((ItemStack)stack, foundNutrients);
        if (!nutrientString.isEmpty()) {
            return I18n.func_135052_a((String)"tooltip.nutrition:nutrients", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + nutrientString + TextFormatting.DARK_AQUA + " (" + String.format("%.1f", Float.valueOf(nutritionValue)) + "%)";
        }
        return nutrientString;
    }

    private static List<Nutrient> getNutrients(NonNullList<ItemStack> ingredients) {
        HashSet foundNutrients = Sets.newHashSet();
        for (ItemStack ing : ingredients) {
            foundNutrients.addAll(NutrientUtils.getFoodNutrients((ItemStack)ing));
        }
        return Lists.newArrayList((Iterable)foundNutrients);
    }
}

