/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.util;

import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class NBTHelper {
    public static final String TAG_INGREDIENTS = "Ingredients";
    public static final String TAG_FOOD = "Food";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_BONUS = "Bonus";

    public static NBTTagCompound getCompoundSafe(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    public static int getBonus(ItemStack stack) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        return compound.func_74762_e(TAG_BONUS);
    }

    public static int getSize(ItemStack stack) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        return compound.func_74762_e(TAG_SIZE);
    }

    public static int getFoodAmount(ItemStack stack) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        return compound.func_74762_e(TAG_FOOD);
    }

    public static float getSaturationModifier(ItemStack stack) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        return compound.func_74760_g(TAG_SATURATION);
    }

    public static NonNullList<ItemStack> getIngredientsList(ItemStack stack, boolean includeBread) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        NBTTagCompound tag = compound.func_74775_l(TAG_INGREDIENTS);
        NonNullList list = NonNullList.func_191197_a((int)(NBTHelper.getSize(stack) + (includeBread ? 1 : 0)), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)list);
        return list;
    }

    public static void setTagBonus(ItemStack stack, int bonus) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        compound.func_74768_a(TAG_BONUS, bonus);
        stack.func_77982_d(compound);
    }

    public static void setTagSize(ItemStack stack, int size) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        compound.func_74768_a(TAG_SIZE, size);
        stack.func_77982_d(compound);
    }

    public static void setTagFood(ItemStack stack, int food) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        compound.func_74768_a(TAG_FOOD, food);
        stack.func_77982_d(compound);
    }

    public static void setTagSaturation(ItemStack stack, float saturation) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        compound.func_74776_a(TAG_SATURATION, saturation);
        stack.func_77982_d(compound);
    }

    public static void setIngredientsList(ItemStack stack, NonNullList<ItemStack> ingredients) {
        NBTTagCompound compound = NBTHelper.getCompoundSafe(stack);
        NBTTagCompound tag = new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, ingredients);
        compound.func_74782_a(TAG_INGREDIENTS, (NBTBase)tag);
        stack.func_77982_d(compound);
    }
}

