/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.inventory;

import c4.culinaryconstruct.CulinaryConstruct;
import c4.culinaryconstruct.api.ICulinaryIngredient;
import c4.culinaryconstruct.common.tileentity.TileEntitySandwichStation;
import c4.culinaryconstruct.common.util.BreadHelper;
import c4.culinaryconstruct.common.util.ConfigHandler;
import c4.culinaryconstruct.common.util.NBTHelper;
import c4.culinaryconstruct.common.util.SandwichHelper;
import c4.culinaryconstruct.proxy.CommonProxy;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockCake;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;
import squeek.applecore.api.food.IEdible;

public class ContainerSandwichStation
extends Container {
    private final InventoryCraftResult outputSlot = new InventoryCraftResult();
    private final IItemHandler ingredientHandler;
    private final BlockPos pos;
    private final World world;
    private String sandwichName;
    private TileEntitySandwichStation sandwichStation;

    public ContainerSandwichStation(InventoryPlayer playerInventory, World world, BlockPos pos, TileEntitySandwichStation te) {
        this.pos = pos;
        this.world = world;
        this.sandwichStation = te;
        this.ingredientHandler = (IItemHandler)this.sandwichStation.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.initSlots(playerInventory);
        this.updateSandwichOutput();
    }

    private void initSlots(InventoryPlayer playerInventory) {
        this.func_75146_a((Slot)new SlotBread(this.ingredientHandler, 0, 10, 50));
        for (int i = 1; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotLayeredIngredient(this.ingredientHandler, i, 12 + i * 18, 50));
        }
        this.func_75146_a(new SlotSandwich((IInventory)this.outputSlot, 6, 150, 50));
        this.addPlayerSlots(playerInventory);
    }

    private void addPlayerSlots(InventoryPlayer playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.world.func_180495_p(this.pos).func_177230_c() == CommonProxy.sandwichStation && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void updateSandwichOutput() {
        ItemStack bread = this.ingredientHandler.getStackInSlot(0);
        if (bread.func_190926_b()) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        NonNullList ingredientsList = NonNullList.func_191196_a();
        int totalFood = 0;
        float totalSaturation = 0.0f;
        int complexity = 0;
        for (int i = 1; i < this.ingredientHandler.getSlots(); ++i) {
            ItemStack copy;
            ItemStack stack = this.ingredientHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICulinaryIngredient) {
                totalFood += ((ICulinaryIngredient)stack.func_77973_b()).getFoodAmount(stack);
            } else if (stack.func_77973_b() instanceof ItemFood) {
                totalFood += ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
            } else if (stack.func_77973_b() instanceof ItemBlockSpecial && ((ItemBlockSpecial)stack.func_77973_b()).getBlock() instanceof BlockCake) {
                totalFood += 14;
            } else {
                this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
                this.func_75142_b();
                return;
            }
            boolean flag = true;
            for (ItemStack existing : ingredientsList) {
                if (existing.func_190926_b() || existing.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != existing.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existing)) continue;
                flag = false;
                break;
            }
            if (flag && !BreadHelper.isValidBread(stack)) {
                ++complexity;
            }
            if ((copy = stack.func_77946_l()).func_190916_E() > 1) {
                copy.func_190920_e(1);
            }
            ingredientsList.add((Object)copy);
        }
        if (bread.func_77973_b() instanceof ItemFood) {
            totalFood += ((ItemFood)bread.func_77973_b()).func_150905_g(bread);
        } else {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        ItemStack copy = bread.func_77946_l();
        if (copy.func_190916_E() > 1) {
            copy.func_190920_e(1);
        }
        ingredientsList.add((Object)copy);
        for (ItemStack stack : ingredientsList) {
            double foodAmount = 0.0;
            double saturationModifier = 0.0;
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (stack.func_77973_b() instanceof ICulinaryIngredient) {
                foodAmount = ((ICulinaryIngredient)stack.func_77973_b()).getFoodAmount(stack);
                saturationModifier = ((ICulinaryIngredient)stack.func_77973_b()).getSaturationModifier(stack);
            } else if (stack.func_77973_b() instanceof ItemFood) {
                foodAmount = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
                saturationModifier = ((ItemFood)stack.func_77973_b()).func_150906_h(stack);
            } else if (stack.func_77973_b() instanceof ItemBlockSpecial && ((ItemBlockSpecial)stack.func_77973_b()).getBlock() instanceof BlockCake) {
                foodAmount = 14.0;
                saturationModifier = 2.8;
            } else if (CulinaryConstruct.isAppleCoreLoaded && item instanceof IEdible) {
                foodAmount = ((IEdible)item).getFoodValues((ItemStack)stack).hunger;
                saturationModifier = ((IEdible)item).getFoodValues((ItemStack)stack).saturationModifier;
            }
            totalSaturation = (float)((double)totalSaturation + foodAmount / (double)totalFood * saturationModifier);
        }
        if (ingredientsList.size() <= 1 || totalFood <= 0 || totalSaturation < 0.0f) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        double count = 1.0;
        int averageFood = MathHelper.func_76143_f((double)((double)totalFood / count));
        while (averageFood > ConfigHandler.maxTotalFood) {
            averageFood = MathHelper.func_76143_f((double)((double)totalFood / (count += 1.0)));
        }
        int size = ingredientsList.size() - 1;
        int bonus = MathHelper.func_76125_a((int)(complexity - (size / 2 + 1)), (int)-2, (int)2);
        ItemStack output = new ItemStack((Item)CommonProxy.sandwich);
        NBTHelper.setTagSize(output, size);
        NBTHelper.setIngredientsList(output, (NonNullList<ItemStack>)ingredientsList);
        NBTHelper.setTagFood(output, averageFood);
        NBTHelper.setTagSaturation(output, totalSaturation *= 1.0f + (float)bonus * 0.2f);
        NBTHelper.setTagBonus(output, bonus);
        if (StringUtils.isBlank((CharSequence)this.sandwichName)) {
            output.func_135074_t();
        } else if (!this.sandwichName.equals(output.func_82833_r())) {
            output.func_151001_c(this.sandwichName);
        }
        output.func_190920_e((int)count);
        this.outputSlot.func_70299_a(0, output);
        this.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 6) {
                if (!this.func_75135_a(itemstack1, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 7 ? index < 43 && !this.func_75135_a(itemstack1, 0, 1, false) && !this.func_75135_a(itemstack1, 1, 6, false) : !this.func_75135_a(itemstack1, 7, 43, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateSandwichName(String newName) {
        this.sandwichName = newName;
        this.updateSandwichOutput();
    }

    private class SlotSandwich
    extends Slot {
        public SlotSandwich(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public void func_75218_e() {
            ContainerSandwichStation.this.updateSandwichOutput();
        }

        @Nonnull
        public ItemStack func_190901_a(EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            IItemHandler ingredients = ContainerSandwichStation.this.ingredientHandler;
            if (ingredients != null) {
                for (int i = 0; i < ingredients.getSlots(); ++i) {
                    ItemStack slot = ingredients.getStackInSlot(i);
                    slot.func_190918_g(1);
                }
            }
            ContainerSandwichStation.this.updateSandwichOutput();
            return stack;
        }
    }

    private class SlotLayeredIngredient
    extends SlotItemHandler {
        public SlotLayeredIngredient(IItemHandler handler, int index, int xPosition, int yPosition) {
            super(handler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return SandwichHelper.isValidIngredient(stack);
        }

        public void func_75218_e() {
            ContainerSandwichStation.this.updateSandwichOutput();
        }
    }

    private class SlotBread
    extends SlotItemHandler {
        public SlotBread(IItemHandler handler, int index, int xPosition, int yPosition) {
            super(handler, index, xPosition, yPosition);
        }

        public void func_75218_e() {
            ContainerSandwichStation.this.updateSandwichOutput();
        }

        public boolean func_75214_a(ItemStack stack) {
            return BreadHelper.isValidBread(stack);
        }
    }
}

