/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WButtonText;
import me.towdium.jecalculation.gui.widgets.WOverlay;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.jei.JecaPlugin;
import me.towdium.jecalculation.utils.IllegalPositionException;
import me.towdium.jecalculation.utils.Utilities;
import mezz.jei.api.recipe.IFocus;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WLabel
implements IWidget {
    public int xPos;
    public int yPos;
    public int xSize;
    public int ySize;
    ILabel label;
    public Mode mode;
    public IWidget.ListenerValue<? super WLabel, ILabel> listener;
    protected Utilities.Timer timer = new Utilities.Timer();

    public WLabel(int xPos, int yPos, int xSize, int ySize, Mode mode) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
        this.label = ILabel.EMPTY;
        this.mode = mode;
    }

    public ILabel getLabel() {
        return this.label;
    }

    public WLabel setLabel(ILabel label) {
        this.label = label;
        return this;
    }

    @Override
    public void onDraw(JecaGui gui, int xMouse, int yMouse) {
        gui.drawResourceContinuous(Resource.WGT_SLOT, this.xPos, this.yPos, this.xSize, this.ySize, 3, 3, 3, 3);
        this.label.drawLabel(gui, this.xPos + this.xSize / 2, this.yPos + this.ySize / 2, true);
        if (this.mode == Mode.RESULT || this.mode == Mode.EDITOR) {
            String s = this.label.getAmountString(this.mode == Mode.RESULT);
            gui.drawText((float)this.xPos + (float)this.xSize / 2.0f + 8.0f - (float)JecaGui.Font.HALF.getTextWidth(s), (float)this.yPos + (float)this.ySize / 2.0f + 8.5f - (float)JecaGui.Font.HALF.getTextHeight(), JecaGui.Font.HALF, s);
        }
        if (this.mode == Mode.EDITOR || this.mode == Mode.SELECTOR) {
            this.timer.setState(gui.hand != ILabel.EMPTY);
            int color = 0xFFFFFF + (int)((-Math.cos((double)this.timer.getTime() * Math.PI / 1500.0) + 1.0) * 64.0) * 0x1000000;
            gui.drawRectangle(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, color);
        }
        if (this.mouseIn(xMouse, yMouse)) {
            gui.drawRectangle(this.xPos + 1, this.yPos + 1, this.xSize - 2, this.ySize - 2, -2130706433);
        }
    }

    @Override
    public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
        if (!this.mouseIn(xMouse, yMouse)) {
            return false;
        }
        if (this.label != ILabel.EMPTY) {
            tooltip.add(this.label.getDisplayName());
            this.label.getToolTip(tooltip, this.mode == Mode.EDITOR || this.mode == Mode.RESULT);
        }
        return false;
    }

    @Override
    public boolean onScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        if (this.mouseIn(xMouse, yMouse)) {
            if (this.mode == Mode.EDITOR && this.label != ILabel.EMPTY) {
                for (int i = 0; i < Math.abs(diff); ++i) {
                    this.label = diff > 0 ? this.label.increaseAmount() : this.label.decreaseAmount();
                }
                this.notifyLsnr();
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ILabel getLabelUnderMouse(int xMouse, int yMouse) {
        return this.mouseIn(xMouse, yMouse) ? this.label : null;
    }

    @Override
    public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (!this.mouseIn(xMouse, yMouse) || button == 1) {
            return false;
        }
        switch (this.mode) {
            case EDITOR: {
                if (gui.hand != ILabel.EMPTY) {
                    this.label = gui.hand;
                    gui.hand = ILabel.EMPTY;
                    this.notifyLsnr();
                    return true;
                }
                if (this.label != ILabel.EMPTY) {
                    gui.root.add(new WAmount());
                    return true;
                }
                return false;
            }
            case RESULT: {
                Object rep = this.label.getRepresentation();
                if (rep != null) {
                    JecaPlugin.runtime.getRecipesGui().show(JecaPlugin.runtime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, rep));
                    return true;
                }
                return false;
            }
            case PICKER: {
                if (this.label != ILabel.EMPTY) {
                    this.notifyLsnr();
                    return true;
                }
                return false;
            }
            case SELECTOR: {
                this.label = gui.hand;
                gui.hand = ILabel.EMPTY;
                this.notifyLsnr();
                return true;
            }
        }
        throw new IllegalPositionException();
    }

    public WLabel setListener(IWidget.ListenerValue<? super WLabel, ILabel> listener) {
        this.listener = listener;
        return this;
    }

    public boolean mouseIn(int x, int y) {
        int xx = x - this.xPos;
        int yy = y - this.yPos;
        return xx >= 0 && xx < this.xSize && yy >= 0 && yy < this.ySize;
    }

    void notifyLsnr() {
        if (this.listener != null) {
            this.listener.invoke(this, this.label);
        }
    }

    class WAmount
    extends WOverlay {
        WLabel temp;
        WButton number;
        WTextField text;
        WButton percent;
        WButton yes;
        WButton no;

        public WAmount() {
            this.temp = new WLabel(WLabel.this.xPos, WLabel.this.yPos, WLabel.this.xSize, WLabel.this.ySize, Mode.PICKER).setListener((i, v) -> this.update());
            this.number = new WButtonText(WLabel.this.xPos + WLabel.this.xSize + 60, WLabel.this.yPos, 20, 20, "#", "general.to_percent").setListener(i -> {
                this.temp.label.setPercent(true);
                this.update();
            });
            this.text = new WTextField(WLabel.this.xPos + WLabel.this.xSize + 10, WLabel.this.yPos + WLabel.this.ySize / 2 - 10, 50);
            this.percent = new WButtonText(WLabel.this.xPos + WLabel.this.xSize + 60, WLabel.this.yPos, 20, 20, "%", "general.to_percent").setListener(i -> {
                this.temp.label.setPercent(false);
                this.update();
            });
            this.yes = new WButtonIcon(WLabel.this.xPos + WLabel.this.xSize + 83, WLabel.this.yPos, 20, 20, Resource.BTN_YES).setListener(i -> {
                WLabel.this.setLabel(this.temp.label);
                WLabel.this.notifyLsnr();
                JecaGui.getCurrent().root.remove(this);
            });
            this.no = new WButtonIcon(WLabel.this.xPos + WLabel.this.xSize + 102, WLabel.this.yPos, 20, 20, Resource.BTN_NO).setListener(i -> {
                WLabel.this.setLabel(ILabel.EMPTY);
                WLabel.this.notifyLsnr();
                JecaGui.getCurrent().root.remove(this);
            });
            this.temp.setLabel(WLabel.this.label.copy());
            this.add((IWidget)new WPanel(WLabel.this.xPos - 5, WLabel.this.yPos - 5, WLabel.this.xSize + 133, WLabel.this.ySize + 10));
            this.add((IWidget)new WText(WLabel.this.xPos + WLabel.this.xSize + 3, WLabel.this.yPos + 5, JecaGui.Font.PLAIN, "x"));
            this.add(this.temp, this.text, this.yes, this.no);
            this.text.setListener(i -> {
                boolean acceptable;
                long amount;
                try {
                    amount = Long.parseLong(this.text.getText());
                    boolean bl = acceptable = amount > 0L;
                    if (!acceptable) {
                        amount = 1L;
                    }
                }
                catch (NumberFormatException e) {
                    acceptable = this.text.getText().isEmpty();
                    amount = 1L;
                }
                this.text.setColor(acceptable ? 0xFFFFFF : 0xFF0000);
                this.yes.setDisabled(!acceptable);
                this.temp.label = this.temp.label.setAmount(amount);
            });
            this.update();
        }

        private void update() {
            this.number.setDisabled(!this.temp.label.acceptPercent());
            if (this.temp.label.isPercent()) {
                this.remove(this.number);
                this.add((IWidget)this.percent);
            } else {
                this.remove(this.percent);
                this.add((IWidget)this.number);
            }
            this.text.setText(Long.toString(this.temp.label.getAmount()));
        }
    }

    public static enum Mode {
        EDITOR,
        RESULT,
        PICKER,
        SELECTOR;

    }
}

