/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.jei.JecaPlugin;
import me.towdium.jecalculation.network.ProxyClient;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class JecaGui
extends GuiContainer {
    public static final int COLOR_GUI_GREY = -6184543;
    public static final int COLOR_TEXT_RED = 0xFF0000;
    public static final int COLOR_TEXT_GREY = 0x404040;
    public static final int COLOR_TEXT_WHITE = 0xFFFFFF;
    public static final boolean ALWAYS_TOOLTIP = false;
    public ILabel hand = ILabel.EMPTY;
    protected static JecaGui last;
    protected static Runnable scheduled;
    protected static int timeout;
    protected JecaGui parent;
    public IGui root;

    public JecaGui(@Nullable JecaGui parent, IGui root) {
        this(parent, false, root);
    }

    public JecaGui(@Nullable JecaGui parent, boolean acceptsTransfer, IGui root) {
        super((Container)(acceptsTransfer ? new ContainerTransfer() : new ContainerNonTransfer()));
        this.parent = parent;
        this.root = root;
        if (this.field_147002_h instanceof JecContainer) {
            ((JecContainer)this.field_147002_h).setGui(this);
        }
    }

    public static int getMouseX() {
        JecaGui gui = JecaGui.getCurrent();
        return Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c - gui.field_147003_i;
    }

    public static int getMouseY() {
        JecaGui gui = JecaGui.getCurrent();
        return gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1 - gui.field_147009_r;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouse(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!(event.getGui() instanceof JecaGui)) {
            return;
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        int button = Mouse.getEventButton();
        if (button == -1) {
            int diff = Mouse.getEventDWheel() / 120;
            if (diff != 0) {
                gui.root.onScroll(gui, xMouse, yMouse, diff);
            }
        } else if (Mouse.getEventButtonState()) {
            if (gui.root.onClicked(gui, xMouse, yMouse, button)) {
                event.setCanceled(true);
            } else if (gui.hand != ILabel.EMPTY) {
                gui.hand = ILabel.EMPTY;
                event.setCanceled(true);
            } else {
                ILabel e = JecaPlugin.getLabelUnderMouse();
                if (e != ILabel.EMPTY) {
                    gui.hand = e;
                    event.setCanceled(true);
                }
            }
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        InventoryBasic i = new InventoryBasic("", false, 1);
        Slot s = new Slot((IInventory)i, 0, 0, 0);
        ILabel l = this.getLabelUnderMouse();
        if (l instanceof LItemStack) {
            s.func_75215_d(((LItemStack)l).getRep());
        }
        return s;
    }

    public void func_73866_w_() {
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public static boolean mouseIn(int xPos, int yPos, int xSize, int ySize, int xMouse, int yMouse) {
        return xMouse > xPos && yMouse > yPos && xMouse <= xPos + xSize && yMouse <= yPos + ySize;
    }

    public static void displayGui(IGui root) {
        JecaGui.displayGui(true, false, root);
    }

    public static void displayGui(boolean updateParent, boolean acceptsTransfer, IGui root) {
        JecaGui.displayGui(updateParent, acceptsTransfer, false, root);
    }

    public static void displayGui(boolean updateParent, boolean acceptsTransfer, boolean scheduled, IGui root) {
        Runnable r = () -> {
            if (Minecraft.func_71410_x().func_152345_ab()) {
                JecaGui.displayGuiUnsafe(updateParent, acceptsTransfer, root);
            }
        };
        if (scheduled) {
            JecaGui.scheduled = r;
            timeout = 2;
        } else {
            r.run();
        }
    }

    public static JecaGui getCurrent() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        JecaGui ret = gui instanceof JecaGui ? (JecaGui)gui : null;
        Objects.requireNonNull(ret);
        return ret;
    }

    private static void displayGuiUnsafe(boolean updateParent, boolean acceptsTransfer, IGui root) {
        Minecraft mc = Minecraft.func_71410_x();
        JecaGui parent = mc.field_71462_r == null ? null : (!(mc.field_71462_r instanceof JecaGui) ? last : (updateParent ? (JecaGui)mc.field_71462_r : ((JecaGui)mc.field_71462_r).parent));
        JecaGui toShow = new JecaGui(parent, acceptsTransfer, root);
        root.onVisible(toShow);
        last = toShow;
        mc.func_147108_a((GuiScreen)toShow);
    }

    public static void displayParent() {
        if (Minecraft.func_71410_x().func_152345_ab()) {
            JecaGui gui = JecaGui.getCurrent().parent;
            gui.root.onVisible(gui);
            last = gui;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        }
    }

    @Nullable
    public ILabel getLabelUnderMouse() {
        int xMouse = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int yMouse = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        return this.root.getLabelUnderMouse(xMouse, yMouse);
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        if (ProxyClient.keyOpenGuiCraft.func_151468_f()) {
            Controller.openGuiCraft();
        }
        if (ProxyClient.keyOpenGuiMath.func_151468_f()) {
            Controller.openGuiMath();
        }
    }

    @SubscribeEvent
    public static void onTooltip(RenderTooltipEvent.Pre event) {
        JecaGui gui;
        if (Minecraft.func_71410_x().field_71462_r instanceof JecaGui && gui.root.onTooltip(gui = JecaGui.getCurrent(), event.getX() - gui.field_147003_i, event.getY() - gui.field_147009_r, new ArrayList<String>()) && !event.getStack().func_190926_b()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameTike(TickEvent.PlayerTickEvent e) {
        if (e.player.field_70170_p.field_72995_K && scheduled != null) {
            if (timeout <= 0) {
                Runnable r = scheduled;
                scheduled = null;
                r.run();
            } else {
                --timeout;
            }
        }
    }

    public static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.root.onDraw(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)80.0f);
        this.hand.drawLabel(this, mouseX, mouseY, true);
        GlStateManager.func_179121_F();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.root.onTooltip(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r, tooltip);
        this.func_146283_a(tooltip, mouseX, mouseY);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int i = 0;
            for (String s : textLines) {
                int j = this.field_146289_q.func_78256_a(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8 + (textLines.size() - 1) * 10;
            if (l1 + i > this.field_146294_l) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_146295_m) {
                i2 = this.field_146295_m - k - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            this.func_73733_a(l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (String s1 : textLines) {
                this.field_146289_q.func_175063_a(s1, (float)l1, (float)i2, -1);
                i2 += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public void drawResource(Resource r, int xPos, int yPos) {
        this.drawResource(r, xPos, yPos, 0xFFFFFF);
    }

    public void drawResource(Resource r, int xPos, int yPos, int color) {
        this.setColor(color);
        this.field_146297_k.func_110434_K().func_110577_a(r.getResourceLocation());
        this.func_73729_b(xPos, yPos, r.getXPos(), r.getYPos(), r.getXSize(), r.getYSize());
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int border) {
        this.drawResourceContinuous(r, xPos, yPos, xSize, ySize, border, border, border, border);
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int borderTop, int borderBottom, int borderLeft, int borderRight) {
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)r.getResourceLocation(), (int)xPos, (int)yPos, (int)r.getXPos(), (int)r.getYPos(), (int)xSize, (int)ySize, (int)r.getXSize(), (int)r.getYSize(), (int)borderTop, (int)borderBottom, (int)borderLeft, (int)borderRight, (float)this.field_73735_i);
    }

    private void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(~(color >> 24) & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void drawFluid(Fluid f, int xPos, int yPos, int xSize, int ySize) {
        TextureAtlasSprite fluidTexture = this.field_146297_k.func_147117_R().getTextureExtry(f.getStill().toString());
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.setColor(f.getColor() & 0xFFFFFF);
        if (fluidTexture != null) {
            this.func_175175_a(xPos, yPos, fluidTexture, xSize, ySize);
        }
    }

    public void drawRectangle(int xPos, int yPos, int xSize, int ySize, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        int right = xPos + xSize;
        int bottom = yPos + ySize;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179118_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)xPos, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)yPos, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xPos, (double)yPos, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public int getStringWidth(String s) {
        return this.field_146289_q.func_78256_a(s);
    }

    public void drawSplitText(float xPos, float yPos, Font f, String s) {
        this.drawSplitText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawSplitText(float xPos, float yPos, int width, Font f, String s) {
        this.drawSplitText(xPos, yPos, f, Utilities.I18n.wrap(s, width));
    }

    public void drawSplitText(float xPos, float yPos, Font f, List<String> ss) {
        this.drawText(xPos, yPos, f, () -> {
            int y = 0;
            for (String i : ss) {
                this.field_146289_q.func_175065_a(i, 0.0f, (float)y, f.color, f.shadow);
                y += this.field_146289_q.field_78288_b + 1;
            }
        });
    }

    public void drawText(float xPos, float yPos, Font f, String s) {
        this.drawText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawText(float xPos, float yPos, int width, Font f, String s) {
        this.drawText(xPos, yPos, f, () -> {
            String str = s;
            int strWidth = f.getTextWidth(str);
            int ellipsisWidth = f.getTextWidth("...");
            if (strWidth > width && strWidth > ellipsisWidth) {
                str = f.trimToWidth(str, width - ellipsisWidth).trim() + "...";
            }
            this.field_146289_q.func_175065_a(str, 0.0f, 0.0f, f.color, f.shadow);
        });
    }

    private void drawText(float xPos, float yPos, Font f, Runnable r) {
        boolean unicode = this.field_146289_q.func_82883_a();
        if (f.raw) {
            this.field_146289_q.func_78264_a(false);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
        if (f.half) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        }
        r.run();
        GlStateManager.func_179121_F();
        this.field_146289_q.func_78264_a(unicode);
    }

    public void drawItemStack(int xPos, int yPos, ItemStack is, boolean centred) {
        if (centred) {
            xPos -= 8;
            yPos -= 8;
        }
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        FontRenderer font = is.func_77973_b().getFontRenderer(is);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(is, xPos, yPos);
        this.field_146296_j.func_180453_a(font, is, xPos, yPos, null);
        this.field_146296_j.func_175042_a(is, xPos, yPos);
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.hand != ILabel.EMPTY) {
            this.hand = ILabel.EMPTY;
        } else if (!this.root.onKey(this, typedChar, keyCode)) {
            if (keyCode == 1 && this.parent != null) {
                JecaGui.displayParent();
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    public static class ContainerNonTransfer
    extends JecContainer {
    }

    public static class ContainerTransfer
    extends JecContainer {
    }

    public static class JecContainer
    extends Container {
        JecaGui gui;

        public JecaGui getGui() {
            return this.gui;
        }

        public void setGui(JecaGui gui) {
            this.gui = gui;
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }

    public static class Font {
        public static final Font SHADOW = new Font(0xFFFFFF, true, false, false);
        public static final Font PLAIN = new Font(0x404040, false, false, false);
        public static final Font RAW = new Font(0x404040, false, false, true);
        public static final Font HALF = new Font(0xFFFFFF, true, true, true);
        public int color;
        public boolean shadow;
        public boolean half;
        public boolean raw;

        public Font(int color, boolean shadow, boolean half, boolean raw) {
            this.color = color;
            this.shadow = shadow;
            this.half = half;
            this.raw = raw;
        }

        public int getTextWidth(String s) {
            FontRenderer fr = JecaGui.getCurrent().field_146289_q;
            boolean flag = fr.func_82883_a();
            if (this.raw) {
                fr.func_78264_a(false);
            }
            int ret = (int)Math.ceil((float)fr.func_78256_a(s) * (this.half ? 0.5f : 1.0f));
            fr.func_78264_a(flag);
            return ret;
        }

        public int getTextHeight() {
            return (int)Math.ceil((float)((JecaGui)JecaGui.getCurrent()).field_146289_q.field_78288_b * (this.half ? 0.5f : 1.0f));
        }

        public String trimToWidth(String s, int i) {
            return JecaGui.getCurrent().field_146289_q.func_78269_a(s, i * (this.half ? 2 : 1));
        }
    }
}

