/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RecordCraft
implements IRecord {
    public static final String KEY_RECENTS = "recents";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_INVENTORY = "inventory";
    Utilities.Recent<ILabel> record = new Utilities.Recent<ILabel>((a, b) -> a == ILabel.EMPTY || a.equals(b), 9);
    public String amount;
    public boolean inventory;

    public RecordCraft(NBTTagCompound nbt) {
        List ls = StreamSupport.stream(nbt.func_150295_c(KEY_RECENTS, 10).spliterator(), false).filter(n -> n instanceof NBTTagCompound).map(n -> ILabel.SERIALIZER.deserialize((NBTTagCompound)n)).collect(Collectors.toList());
        new Utilities.ReversedIterator(ls).forEachRemaining(l -> this.record.push((ILabel)l, false));
        this.amount = nbt.func_74779_i(KEY_AMOUNT);
        this.inventory = nbt.func_74767_n(KEY_INVENTORY);
    }

    public boolean push(ILabel label, boolean replace) {
        return this.record.push(label, replace);
    }

    public ILabel getLatest() {
        return this.record.size() == 0 ? ILabel.EMPTY : this.record.toList().get(0);
    }

    public List<ILabel> getHistory() {
        return this.record.size() > 1 ? this.record.toList().subList(1, this.record.size()) : new ArrayList<ILabel>();
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74757_a(KEY_INVENTORY, this.inventory);
        ret.func_74778_a(KEY_AMOUNT, this.amount);
        NBTTagList recent = new NBTTagList();
        this.record.toList().forEach(l -> recent.func_74742_a((NBTBase)ILabel.SERIALIZER.serialize((ILabel)l)));
        ret.func_74782_a(KEY_RECENTS, (NBTBase)recent);
        return ret;
    }
}

