/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CostList {
    List<ILabel> labels;

    public CostList() {
        this.labels = new ArrayList<ILabel>();
    }

    public CostList(List<ILabel> labels) {
        this.labels = labels.stream().filter(i -> i != ILabel.EMPTY).map(i -> i.copy().multiply(-1.0f)).collect(Collectors.toList());
    }

    public CostList(List<ILabel> positive, List<ILabel> negative) {
        this(positive);
        this.multiply(-1L);
        this.merge(new CostList(negative), false, true);
    }

    public CostList merge(CostList costList, boolean strict, boolean inplace) {
        CostList ret = inplace ? this : this.copy();
        costList.labels.forEach(i -> ret.labels.add(i.copy()));
        for (int i2 = 0; i2 < ret.labels.size(); ++i2) {
            for (int j = i2 + 1; j < ret.labels.size(); ++j) {
                if (strict) {
                    ILabel b;
                    ILabel a = ret.labels.get(i2);
                    if (!a.matches(b = ret.labels.get(j))) continue;
                    ret.labels.set(i2, a.setAmount(Math.addExact(a.getAmount(), b.getAmount())));
                    ret.labels.set(j, ILabel.EMPTY);
                    continue;
                }
                Optional<ILabel> l = ILabel.MERGER.merge(ret.labels.get(i2), ret.labels.get(j));
                if (!l.isPresent()) continue;
                ret.labels.set(i2, l.get());
                ret.labels.set(j, ILabel.EMPTY);
            }
        }
        ret.labels = ret.labels.stream().filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
        return ret;
    }

    public CostList multiply(long i) {
        this.labels = this.labels.stream().map(j -> j.multiply(i)).collect(Collectors.toList());
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CostList) {
            CostList c = (CostList)obj;
            CostList m = c.copy().multiply(-1L);
            return this.merge((CostList)m, (boolean)true, (boolean)false).labels.isEmpty();
        }
        return false;
    }

    public CostList copy() {
        CostList ret = new CostList();
        ret.labels = this.labels.stream().map(ILabel::copy).collect(Collectors.toList());
        return ret;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public List<ILabel> getLabels() {
        return this.labels;
    }

    public Calculator calculate() {
        return new Calculator();
    }

    public int hashCode() {
        int hash = 0;
        for (ILabel i : this.labels) {
            hash ^= i.hashCode();
        }
        return hash;
    }

    public class Calculator {
        ArrayList<Pair<CostList, CostList>> procedure = new ArrayList();
        ArrayList<ILabel> catalysts = new ArrayList();
        Recipes.RecipeIterator iterator = Controller.recipeIterator();
        private int index;

        public Calculator() throws ArithmeticException {
            HashSet<CostList> set = new HashSet<CostList>();
            set.add(CostList.this);
            Pair<Recipe, Long> next = this.find(true);
            int count = 0;
            while (next != null) {
                CostList original = this.getCurrent();
                List<ILabel> outL = Arrays.stream(((Recipe)next.one).getLabel(Recipe.IO.OUTPUT)).filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
                CostList outC = new CostList(outL);
                outC.multiply(-((Long)next.two).longValue());
                List<ILabel> inL = Arrays.stream(((Recipe)next.one).getLabel(Recipe.IO.INPUT)).filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
                CostList inC = new CostList(inL);
                inC.multiply((Long)next.two);
                CostList result = original.merge(outC, false, false);
                result.merge(inC, false, true);
                if (set.contains(result)) {
                    next = this.find(false);
                } else {
                    set.add(result);
                    this.procedure.add(new Pair<CostList, CostList>(result, outC));
                    this.addCatalyst(((Recipe)next.one).getLabel(Recipe.IO.CATALYST));
                    next = this.find(true);
                }
                if (count++ <= 1000) continue;
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("jecalculation.chat.max_loop", new Object[0]));
                break;
            }
        }

        @Nullable
        private Pair<Recipe, Long> find(boolean reset) {
            if (reset) {
                this.index = 0;
                this.iterator = Controller.recipeIterator();
            }
            List<ILabel> labels = this.getCurrent().labels;
            while (this.index < labels.size()) {
                ILabel label = labels.get(this.index);
                if (label.getAmount() < 0L) {
                    while (this.iterator.hasNext()) {
                        Recipe r = this.iterator.next();
                        if (!r.matches(label).isPresent()) continue;
                        return new Pair<Recipe, Long>(r, r.multiplier(label));
                    }
                    this.iterator = Controller.recipeIterator();
                }
                ++this.index;
            }
            return null;
        }

        private void addCatalyst(ILabel[] labels) {
            Arrays.stream(labels).filter(i -> i != ILabel.EMPTY).forEach(i -> this.catalysts.stream().filter(j -> j.matches(i)).findAny().map(j -> j.setAmount(Math.max(i.getAmount(), j.getAmount()))).orElseGet(Utilities.fake(() -> this.catalysts.add((ILabel)i))));
        }

        private CostList getCurrent() {
            return this.procedure.isEmpty() ? CostList.this : (CostList)this.procedure.get((int)(this.procedure.size() - 1)).one;
        }

        public List<ILabel> getCatalysts() {
            return this.catalysts;
        }

        public List<ILabel> getInputs() {
            return this.getCurrent().labels.stream().filter(i -> i.getAmount() < 0L).map(i -> i.copy().multiply(-1.0f)).collect(Collectors.toList());
        }

        public List<ILabel> getOutputs(List<ILabel> ignore) {
            return this.getCurrent().labels.stream().map(i -> i.copy().multiply(-1.0f)).map(i -> ignore.stream().flatMap(j -> Utilities.stream(ILabel.MERGER.merge((ILabel)i, (ILabel)j))).findFirst().orElse(i)).filter(i -> i != ILabel.EMPTY && i.getAmount() < 0L).map(i -> i.multiply(-1.0f)).collect(Collectors.toList());
        }

        public List<ILabel> getSteps() {
            List<ILabel> ret = this.procedure.stream().map(i -> ((CostList)i.two).labels.get(0)).collect(Collectors.toList());
            Collections.reverse(ret);
            return ret;
        }
    }
}

