/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class LPlaceholder
extends ILabel.Impl {
    public static final String KEY_NAME = "name";
    public static final String IDENTIFIER = "placeholder";
    static Utilities.Recent<LPlaceholder> recentClient = new Utilities.Recent(100);
    static Utilities.Recent<LPlaceholder> recentServer = new Utilities.Recent(100);
    String name;

    public LPlaceholder(NBTTagCompound tag) {
        super(tag);
        this.name = tag.func_74779_i(KEY_NAME);
    }

    public LPlaceholder(String name, long amount) {
        this(name, amount, false);
    }

    public LPlaceholder(String name, long amount, boolean silent) {
        super(amount, false);
        this.name = name;
        if (!silent) {
            LPlaceholder.getRecord().push(new LPlaceholder(name, 1L, true), false);
        }
    }

    public LPlaceholder(LPlaceholder label) {
        super(label);
        this.name = label.name;
    }

    @SubscribeEvent
    public static void onLogOut(PlayerEvent.PlayerLoggedOutEvent e) {
        recentServer.clear();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    public static List<ILabel> getRecent() {
        return LPlaceholder.getRecord().toList().stream().map(LPlaceholder::copy).collect(Collectors.toList());
    }

    private static Utilities.Recent<LPlaceholder> getRecord() {
        return Controller.isServerActive() ? recentClient : recentServer;
    }

    @Override
    public NBTTagCompound toNbt() {
        NBTTagCompound nbt = super.toNbt();
        nbt.func_74778_a(KEY_NAME, this.name);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawResource(Resource.LBL_UNIV_B, 0, 0);
        gui.drawResource(Resource.LBL_UNIV_F, 0, 0, this.name.hashCode() * 1251107 & 0xFFFFFF);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    @Override
    @Nullable
    public Object getRepresentation() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return Utilities.I18n.get("label.placeholder.name", this.name);
    }

    @Override
    public boolean matches(Object l) {
        return l instanceof LPlaceholder && this.name.equals(((LPlaceholder)l).name) && super.matches(l);
    }

    @Override
    public LPlaceholder copy() {
        return new LPlaceholder(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LPlaceholder && b instanceof LPlaceholder) {
            LPlaceholder lpA = (LPlaceholder)a;
            LPlaceholder lpB = (LPlaceholder)b;
            return lpA.name.equals(lpB.name);
        }
        return false;
    }
}

