/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.JecaCapability;
import me.towdium.jecalculation.JecaConfig;
import me.towdium.jecalculation.JecaItem;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.data.structure.RecordMath;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.GuiCraft;
import me.towdium.jecalculation.gui.guis.GuiMath;
import me.towdium.jecalculation.network.packets.PCalculator;
import me.towdium.jecalculation.network.packets.PEdit;
import me.towdium.jecalculation.network.packets.PRecord;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Controller {
    public static final String KEY_MATH = "math";
    public static final String KEY_CRAFT = "craft";
    public static final String KEY_PLAYER = "player";
    static RecordPlayer rPlayerServer;
    static RecordPlayer rPlayerClient;
    static RecordCraft rCraftClient;
    static RecordMath rMathClient;

    public static void setRecordsServer(RecordPlayer r) {
        rPlayerServer = r;
    }

    public static boolean isServerActive() {
        return rPlayerServer != null;
    }

    static Recipes getRecipes() {
        if (Controller.isServerActive()) {
            return Controller.rPlayerServer.recipes;
        }
        return Controller.rPlayerClient.recipes;
    }

    public static Optional<ItemStack> getStack() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack is = player.func_184586_b(EnumHand.MAIN_HAND);
        if (is.func_77973_b() instanceof JecaItem) {
            return Optional.of(is);
        }
        is = player.func_184586_b(EnumHand.OFF_HAND);
        return Optional.ofNullable(is.func_77973_b() instanceof JecaItem ? is : null);
    }

    public static List<Pair<String, Recipes>> discover() {
        File dir = new File(Loader.instance().getConfigDir(), "JustEnoughCalculation/data/");
        File[] fs = dir.listFiles();
        Function<File, Recipes> read = f -> {
            NBTTagCompound nbt = Utilities.Json.read(f);
            JustEnoughCalculation.logger.warn("File " + f.getAbsolutePath() + " contains invalid records.");
            return nbt == null ? null : new Recipes(nbt);
        };
        if (fs == null) {
            return new ArrayList<Pair<String, Recipes>>();
        }
        return Arrays.stream(fs).map(i -> new Pair(i.getName(), read.apply((File)i))).filter(i -> i.two != null).collect(Collectors.toList());
    }

    public static void inport(Recipes recipes, String group) {
        ArrayList buffer = new ArrayList();
        recipes.getGroup(group).stream().filter(i -> !Controller.hasDuplicate(i)).forEach(buffer::add);
        for (Recipe r : buffer) {
            Controller.addRecipe(group, r);
        }
    }

    private static void export(String s, Function<Recipes, NBTTagCompound> r) {
        File f = new File(Loader.instance().getConfigDir(), "JustEnoughCalculation/data/" + s + ".json");
        Utilities.Json.write(r.apply(Controller.getRecipes()), f);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("jecalculation.chat.export", new Object[]{f.getAbsolutePath()}));
    }

    public static void export(String group) {
        Controller.export(group, i -> i.serialize(Collections.singleton(group)));
    }

    public static void export() {
        Controller.export("groups", Recipes::serialize);
    }

    @Nullable
    public static String getLast() {
        return Controller.isServerActive() ? Controller.rPlayerServer.last : Controller.rPlayerClient.last;
    }

    static void setLast(String last) {
        if (Controller.isServerActive()) {
            Controller.rPlayerServer.last = last;
        } else {
            Controller.rPlayerClient.last = last;
        }
    }

    public static List<String> getGroups() {
        return Controller.getRecipes().getGroups();
    }

    public static void setRecipe(String neu, String old, int index, Recipe recipe) {
        Controller.getRecipes().set(neu, old, index, recipe);
        Controller.setLast(neu);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((IMessage)new PEdit(neu, old, index, recipe));
        }
    }

    public static void renameGroup(String old, String neu) {
        Controller.getRecipes().renameGroup(old, neu);
        Controller.setLast(neu);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((IMessage)new PEdit(neu, old, -1, null));
        }
    }

    public static void addRecipe(String group, Recipe recipe) {
        Controller.getRecipes().add(group, recipe);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((IMessage)new PEdit(group, null, -1, recipe));
        }
    }

    public static void setRecipe(String group, int index, Recipe recipe) {
        Controller.getRecipes().set(group, index, recipe);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((IMessage)new PEdit(group, null, index, recipe));
        }
    }

    public static void removeRecipe(String group, int index) {
        Controller.getRecipes().remove(group, index);
        Controller.setLast(group);
        if (Controller.isServerActive()) {
            JustEnoughCalculation.network.sendToServer((IMessage)new PEdit(group, null, index, null));
        }
    }

    public static Recipe getRecipe(String group, int index) {
        return Controller.getRecipes().getRecipe(group, index);
    }

    public static Stream<Pair<String, List<Recipe>>> stream() {
        return Controller.getRecipes().stream();
    }

    public static Recipes.RecipeIterator recipeIterator() {
        return Controller.getRecipes().recipeIterator();
    }

    public static Recipes.RecipeIterator recipeIterator(String group) {
        return Controller.getRecipes().recipeIterator(group);
    }

    public static void setRMath(RecordMath math) {
        Controller.setR(math, i -> {
            rMathClient = i;
        }, KEY_MATH);
    }

    public static void setRCraft(RecordCraft rc) {
        Controller.setR(rc, i -> {
            rCraftClient = i;
        }, KEY_CRAFT);
    }

    public static RecordCraft getRCraft() {
        return Controller.getR(rCraftClient, KEY_CRAFT, RecordCraft::new);
    }

    public static RecordMath getRMath() {
        return Controller.getR(rMathClient, KEY_MATH, RecordMath::new);
    }

    private static <T extends IRecord> void setR(T t, Consumer<T> c, String s) {
        if (!Controller.isServerActive()) {
            c.accept(t);
        } else {
            Optional<ItemStack> ois = Controller.getStack();
            ois.ifPresent(is -> {
                Utilities.getTag(is).func_74782_a(s, (NBTBase)t.serialize());
                JustEnoughCalculation.network.sendToServer((IMessage)new PCalculator((ItemStack)is));
            });
        }
    }

    public static <T> T getR(T t, String s, Function<NBTTagCompound, T> f) {
        if (!Controller.isServerActive()) {
            return t;
        }
        return f.apply(Controller.getStack().map(i -> Utilities.getTag(i).func_74775_l(s)).orElse(new NBTTagCompound()));
    }

    public static boolean hasDuplicate(Recipe r, String group, int index) {
        Recipes.RecipeIterator ri = Controller.recipeIterator();
        return ri.stream().anyMatch(i -> {
            if (ri.getIndex() == index && ri.getGroup().equals(group)) {
                return false;
            }
            return i.equals(r);
        });
    }

    public static boolean hasDuplicate(Recipe r) {
        return Controller.recipeIterator().stream().anyMatch(i -> i.equals(r));
    }

    public static void loadFromLocal() {
        new File(Loader.instance().getConfigDir(), "JustEnoughCalculation/data").mkdirs();
        File file = new File(Loader.instance().getConfigDir(), "JustEnoughCalculation/record.json");
        NBTTagCompound nbt = Utilities.Json.read(file);
        if (nbt != null) {
            rCraftClient = new RecordCraft(nbt.func_74775_l(KEY_CRAFT));
            rMathClient = new RecordMath(nbt.func_74775_l(KEY_MATH));
            rPlayerClient = nbt.func_74764_b(KEY_PLAYER) ? new RecordPlayer(nbt.func_74775_l(KEY_PLAYER)) : new RecordPlayer();
        } else {
            rPlayerClient = new RecordPlayer();
            rCraftClient = new RecordCraft(new NBTTagCompound());
            rMathClient = new RecordMath(new NBTTagCompound());
        }
    }

    public static void writeToLocal() {
        File file = new File(Loader.instance().getConfigDir(), "JustEnoughCalculation/record.json");
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(KEY_CRAFT, (NBTBase)rCraftClient.serialize());
        nbt.func_74782_a(KEY_PLAYER, (NBTBase)rPlayerClient.serialize());
        nbt.func_74782_a(KEY_MATH, (NBTBase)rMathClient.serialize());
        Utilities.Json.write(nbt, file);
    }

    public static void openGuiCraft() {
        Controller.openGuiCraft(false);
    }

    public static void openGuiMath() {
        Controller.openGuiMath(false);
    }

    public static void openGuiCraft(boolean scheduled) {
        if (!Controller.isServerActive()) {
            JecaGui.displayGui(true, true, scheduled, new GuiCraft());
        } else {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("jecalculation.chat.server_mode", new Object[0]));
        }
    }

    public static void openGuiMath(boolean scheduled) {
        if (!Controller.isServerActive()) {
            JecaGui.displayGui(true, true, scheduled, new GuiMath());
        } else {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("jecalculation.chat.server_mode", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onLogOut(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Controller.writeToLocal();
        rPlayerServer = null;
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!JecaConfig.clientMode) {
            JustEnoughCalculation.network.sendTo((IMessage)new PRecord(JecaCapability.getRecord(e.player)), (EntityPlayerMP)e.player);
        }
    }
}

