/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class JecaCapability {
    @CapabilityInject(value=Container.class)
    public static final Capability<Container> CAPABILITY_RECORD = null;

    public static RecordPlayer getRecord(EntityPlayer player) {
        return ((Container)player.getCapability(CAPABILITY_RECORD, EnumFacing.UP)).getRecord();
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayerMP) {
            e.addCapability(new ResourceLocation("jecalculation", "record"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public static void onCloneCapability(PlayerEvent.Clone e) {
        RecordPlayer r = JecaCapability.getRecord(e.getOriginal());
        ((Container)e.getEntityPlayer().getCapability(CAPABILITY_RECORD, EnumFacing.UP)).setRecord(r);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        Container container = new Container();

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_RECORD;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY_RECORD ? this.container : null);
        }

        public NBTTagCompound serializeNBT() {
            return this.container.getRecord().serialize();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.container.setRecord(new RecordPlayer(nbt));
        }
    }

    public static class Storage
    implements Capability.IStorage<Container> {
        public NBTBase writeNBT(Capability<Container> capability, Container instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<Container> capability, Container instance, EnumFacing side, NBTBase nbt) {
        }
    }

    public static class Container {
        RecordPlayer record;

        public RecordPlayer getRecord() {
            if (this.record == null) {
                this.record = new RecordPlayer();
            }
            return this.record;
        }

        public void setRecord(RecordPlayer r) {
            this.record = r;
        }
    }
}

