/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.core.transformer;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MidnightClassTransformer
implements IClassTransformer,
Opcodes {
    private static final String SOURCE_LWJGL_NAME = "paulscode/sound/libraries/SourceLWJGLOpenAL";
    private static final String CHANNEL_LWJGL_NAME = "paulscode/sound/libraries/ChannelLWJGLOpenAL";
    private static final String GL_STATE_MANAGER_NAME = "net/minecraft/client/renderer/GlStateManager";
    private static final String ENTITY_LIVING_BASE_NAME = "net/minecraft/entity/EntityLivingBase";
    private static final Logger LOGGER = LogManager.getLogger(MidnightClassTransformer.class);

    public byte[] transform(String name, String transformedName, byte[] data) {
        if (data == null) {
            return null;
        }
        if (transformedName.equals("paulscode.sound.libraries.SourceLWJGLOpenAL")) {
            return this.applyTransform(transformedName, data, this::transformSoundSource);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            return this.applyTransform(transformedName, data, this::transformRenderLivingBase);
        }
        return data;
    }

    private boolean transformSoundSource(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("play")) continue;
            this.insertBefore(method.instructions, this.invoke(SOURCE_LWJGL_NAME, "checkPitch"::equals), () -> {
                InsnList instructions = new InsnList();
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, SOURCE_LWJGL_NAME, "channelOpenAL", "Lpaulscode/sound/libraries/ChannelLWJGLOpenAL;"));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, CHANNEL_LWJGL_NAME, "ALSource", "Ljava/nio/IntBuffer;"));
                instructions.add((AbstractInsnNode)new InsnNode(3));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/nio/IntBuffer", "get", "(I)I", false));
                instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/mushroom/midnight/client/SoundReverbHandler", "onPlaySound", "(I)V", false));
                return instructions;
            });
            return true;
        }
        return false;
    }

    private boolean transformRenderLivingBase(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("applyRotations") && !method.name.equals("func_77043_a")) continue;
            this.insertAfter(method.instructions, this.invoke(GL_STATE_MANAGER_NAME, n -> n.equals("rotate") || n.equals("func_179114_b")), () -> {
                InsnList instructions = new InsnList();
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/mushroom/midnight/client/ClientEventHandler", "onApplyRotations", "(Lnet/minecraft/entity/EntityLivingBase;)V", false));
                return instructions;
            });
            return true;
        }
        return false;
    }

    private byte[] applyTransform(String name, byte[] data, Predicate<ClassNode> transformer) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)node, 0);
        if (transformer.test(node)) {
            ClassWriter writer = new ClassWriter(1);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        LOGGER.warn("Unable to patch class {}", (Object)name);
        return data;
    }

    private void insertBefore(InsnList instructions, Predicate<AbstractInsnNode> predicate, Supplier<InsnList> insert) {
        AbstractInsnNode node = this.selectNode(instructions, predicate);
        if (node != null) {
            instructions.insertBefore(node, insert.get());
        } else {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            LOGGER.warn("Failed to find location to insert for {}", (Object)stackTrace[1].getMethodName());
        }
    }

    private void insertAfter(InsnList instructions, Predicate<AbstractInsnNode> predicate, Supplier<InsnList> insert) {
        AbstractInsnNode node = this.selectNode(instructions, predicate);
        if (node != null) {
            instructions.insert(node, insert.get());
        } else {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            LOGGER.warn("Failed to find location to insert for {}", (Object)stackTrace[1].getMethodName());
        }
    }

    @Nullable
    private AbstractInsnNode selectNode(InsnList instructions, Predicate<AbstractInsnNode> predicate) {
        for (AbstractInsnNode node : instructions) {
            if (!predicate.test(node)) continue;
            return node;
        }
        return null;
    }

    private Predicate<AbstractInsnNode> invoke(String owner, Predicate<String> name) {
        return n -> n instanceof MethodInsnNode && ((MethodInsnNode)n).owner.equals(owner) && name.test(((MethodInsnNode)n).name);
    }
}

