/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.config;

import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UndergroundPlacementConfig
implements IPlacementConfig {
    private final int minCount;
    private final int maxCount;
    private final int minHeight;
    private final int maxHeight;

    public UndergroundPlacementConfig(int minCount, int maxCount, int minHeight, int maxHeight) {
        if (minCount <= maxCount) {
            this.minCount = minCount;
            this.maxCount = maxCount;
        } else {
            this.minCount = maxCount;
            this.maxCount = minCount;
        }
        if (minHeight <= maxHeight) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        } else {
            this.minHeight = maxHeight;
            this.maxHeight = minHeight;
        }
    }

    public UndergroundPlacementConfig(int count, int minHeight, int maxHeight) {
        this(count, count, minHeight, maxHeight);
    }

    @Override
    public void apply(World world, SurfacePlacementLevel placementLevel, Random random, BlockPos chunkOrigin, Consumer<BlockPos> generator) {
        int count = this.minCount;
        if (this.minCount != this.maxCount) {
            count = random.nextInt(this.maxCount - this.minCount + 1) + this.minCount;
        }
        block0: for (int i = 0; i < count; ++i) {
            int offsetX = random.nextInt(16) + 8;
            int offsetZ = random.nextInt(16) + 8;
            int maxY = Math.min(world.func_181545_F(), world.func_189649_b(chunkOrigin.func_177958_n() + offsetX, chunkOrigin.func_177952_p() + offsetZ));
            if (maxY <= 0) continue;
            int currentMaxHeight = Math.min(this.maxHeight, maxY);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(chunkOrigin.func_177982_a(offsetX, Math.min(this.minHeight, maxY), offsetZ));
            while (mutablePos.func_177956_o() <= currentMaxHeight) {
                if (world.func_175623_d((BlockPos)mutablePos)) {
                    generator.accept(mutablePos.func_185334_h());
                    continue block0;
                }
                mutablePos.func_189536_c(EnumFacing.UP);
            }
        }
    }
}

