/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.config;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ScatterPlacementConfig
implements IPlacementConfig {
    private final int count;
    private final int scatterCount;

    public ScatterPlacementConfig(int count, int scatterCount) {
        this.count = count;
        this.scatterCount = scatterCount;
    }

    @Override
    public void apply(World world, SurfacePlacementLevel placementLevel, Random random, BlockPos chunkOrigin, Consumer<BlockPos> generator) {
        for (int i = 0; i < this.count; ++i) {
            int offsetZ;
            int offsetX = random.nextInt(16) + 8;
            BlockPos pos = chunkOrigin.func_177982_a(offsetX, 0, offsetZ = random.nextInt(16) + 8);
            int maxY = placementLevel.getSurfacePos(world, pos).func_177956_o() + 32;
            if (maxY <= 0) continue;
            this.applyScatter(world, random, pos.func_177981_b(placementLevel.generateUpTo(world, random, maxY)), generator);
        }
    }

    private void applyScatter(World world, Random random, BlockPos pos, Consumer<BlockPos> generator) {
        IBlockState state;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        while (mutablePos.func_177956_o() > 0 && ((state = world.func_180495_p((BlockPos)mutablePos)).func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)mutablePos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mutablePos))) {
            mutablePos.func_189536_c(EnumFacing.DOWN);
        }
        pos = mutablePos.func_185334_h();
        for (int i = 0; i < this.scatterCount; ++i) {
            int offsetX = random.nextInt(8) - random.nextInt(8);
            int offsetY = random.nextInt(4) - random.nextInt(4);
            int offsetZ = random.nextInt(8) - random.nextInt(8);
            mutablePos.func_181079_c(pos.func_177958_n() + offsetX, pos.func_177956_o() + offsetY, pos.func_177952_p() + offsetZ);
            IBlockState existingState = world.func_180495_p((BlockPos)mutablePos);
            if (!existingState.func_177230_c().isAir(existingState, (IBlockAccess)world, (BlockPos)mutablePos) || existingState.func_177230_c() == ModBlocks.MUSHROOM_INSIDE) continue;
            generator.accept(mutablePos.func_185334_h());
        }
    }
}

