/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.world.feature.MidnightAbstractFeature;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrystalClusterFeature
extends MidnightAbstractFeature {
    private final int radius;
    private final int maxHeight;
    private final IBlockState rock;
    private final IBlockState crystal;

    public CrystalClusterFeature(int radius, int maxHeight, IBlockState rock, IBlockState crystal) {
        this.radius = radius;
        this.maxHeight = maxHeight;
        this.rock = rock;
        this.crystal = crystal;
    }

    @Override
    public boolean placeFeature(World world, Random rand, BlockPos origin) {
        int size = this.radius * 2 + 1;
        int[] heights = new int[size * size];
        BlockPos basePos = this.populateHeights(world, rand, origin, heights, size);
        if (basePos == null || !this.canGenerate(world, origin, heights, size)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int localZ = -this.radius; localZ <= this.radius; ++localZ) {
            for (int localX = -this.radius; localX <= this.radius; ++localX) {
                int height = heights[localX + this.radius + (localZ + this.radius) * size];
                if (height <= 0) continue;
                mutablePos.func_181079_c(basePos.func_177958_n() + localX, basePos.func_177956_o(), basePos.func_177952_p() + localZ);
                this.generatePillar(world, rand, mutablePos, height);
            }
        }
        return true;
    }

    private BlockPos populateHeights(World world, Random rand, BlockPos origin, int[] heights, int size) {
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(origin);
        for (int localZ = -this.radius; localZ <= this.radius; ++localZ) {
            for (int localX = -this.radius; localX <= this.radius; ++localX) {
                double deltaZ;
                int index = localX + this.radius + (localZ + this.radius) * size;
                double deltaX = (double)localX + rand.nextDouble() * 2.0 - 1.0;
                double distance = Math.sqrt(deltaX * deltaX + (deltaZ = (double)localZ + rand.nextDouble() * 2.0 - 1.0) * deltaZ);
                double alpha = ((double)this.radius - distance) / (double)this.radius;
                int height = MathHelper.func_76128_c((double)(alpha * (double)this.maxHeight));
                if (height <= 0) continue;
                BlockPos surfacePos = this.findSurfaceBelow(world, origin.func_177982_a(localX, 0, localZ), 16);
                if (surfacePos == null) {
                    return null;
                }
                if (surfacePos.func_177956_o() < basePos.func_177956_o()) {
                    basePos.func_185336_p(surfacePos.func_177956_o());
                }
                heights[index] = height;
            }
        }
        return basePos.func_185334_h();
    }

    private boolean canGenerate(World world, BlockPos origin, int[] heights, int size) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(origin);
        int centerHeight = heights[this.radius + this.radius * size] + 1;
        for (int localY = 0; localY < centerHeight; ++localY) {
            mutablePos.func_185336_p(origin.func_177956_o() + localY);
            if (world.func_175623_d((BlockPos)mutablePos)) continue;
            return false;
        }
        return true;
    }

    private void generatePillar(World world, Random rand, BlockPos.MutableBlockPos mutablePos, int height) {
        int originY = mutablePos.func_177956_o();
        for (int offsetY = 0; offsetY < height; ++offsetY) {
            mutablePos.func_185336_p(originY + offsetY);
            this.trySetBlock(world, (BlockPos)mutablePos, this.rock);
        }
        if (rand.nextInt(2) == 0) {
            mutablePos.func_185336_p(originY + height);
            this.trySetBlock(world, (BlockPos)mutablePos, this.crystal);
        }
    }

    private BlockPos findSurfaceBelow(World world, BlockPos origin, int maxSteps) {
        IBlockState currentState = world.func_180495_p(origin);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(origin);
        for (int i = 0; i < maxSteps; ++i) {
            currentPos.func_189536_c(EnumFacing.DOWN);
            IBlockState nextState = world.func_180495_p((BlockPos)currentPos);
            if (currentState.func_177230_c() == Blocks.field_150350_a && nextState.isSideSolid((IBlockAccess)world, (BlockPos)currentPos, EnumFacing.UP)) {
                currentPos.func_189536_c(EnumFacing.UP);
                return currentPos.func_185334_h();
            }
            currentState = nextState;
        }
        return null;
    }

    private void trySetBlock(World world, BlockPos pos, IBlockState state) {
        IBlockState currentState = world.func_180495_p(pos);
        if (currentState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            world.func_180501_a(pos, state, 3);
        }
    }
}

