/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.BiomeLayerSampler;
import com.mushroom.midnight.common.biome.BiomeLayerType;
import com.mushroom.midnight.common.capability.MultiLayerBiomeSampler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class MidnightBiomeProvider
extends BiomeProvider {
    private static final BiomeLayerSampler<Biome> DEFAULT_SAMPLER = new BiomeLayerSampler.Constant<Biome>(Biomes.field_180279_ad);
    private final World world;
    private final BiomeLayerType<Biome> sampleLayer;

    public MidnightBiomeProvider(World world, BiomeLayerType<Biome> sampleLayer) {
        super(world.func_72912_H());
        this.world = world;
        this.sampleLayer = sampleLayer;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        return this.getSampler().sampleNoise((Biome[])biomes, x, z, width, height);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomes, int x, int z, int width, int height, boolean cacheFlag) {
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        return this.getSampler().sample((Biome[])biomes, x, z, width, height);
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        Biome[] biomes;
        int minX = x - radius >> 2;
        int minZ = z - radius >> 2;
        int maxX = x + radius >> 2;
        int maxZ = z + radius >> 2;
        int width = maxX - minX + 1;
        int height = maxZ - minZ + 1;
        for (Biome biome : biomes = this.getSampler().sampleNoise((Biome[])new Biome[width * height], minX, minZ, width, height)) {
            if (allowed.contains(biome)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int minX = x - range >> 2;
        int minZ = z - range >> 2;
        int maxX = x + range >> 2;
        int maxZ = z + range >> 2;
        int width = maxX - minX + 1;
        int height = maxZ - minZ + 1;
        Biome[] sampledBiomes = this.getSampler().sampleNoise((Biome[])new Biome[width * height], minX, minZ, width, height);
        BlockPos pos = null;
        int count = 0;
        for (int index = 0; index < sampledBiomes.length; ++index) {
            int biomeX = minX + index % width << 2;
            int biomeZ = minZ + index / width << 2;
            Biome biome = sampledBiomes[index];
            if (!biomes.contains(biome) || pos != null && random.nextInt(count + 1) != 0) continue;
            pos = new BlockPos(biomeX, 0, biomeZ);
            ++count;
        }
        return pos;
    }

    private BiomeLayerSampler<Biome> getSampler() {
        BiomeLayerSampler<Biome> layer;
        MultiLayerBiomeSampler multiLayerSampler = (MultiLayerBiomeSampler)this.world.getCapability(Midnight.MULTI_LAYER_BIOME_SAMPLER_CAP, null);
        if (multiLayerSampler != null && (layer = multiLayerSampler.getLayer(this.sampleLayer)) != null) {
            return layer;
        }
        return DEFAULT_SAMPLER;
    }
}

