/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class EntityUtil {
    private static final Map<Class<? extends EntityLivingBase>, Stance> STANCES = new HashMap<Class<? extends EntityLivingBase>, Stance>();

    public static void onPreInit() {
        EntityUtil.registerStance(EntitySpider.class, Stance.QUADRUPEDAL);
        EntityUtil.registerStance(EntityCaveSpider.class, Stance.QUADRUPEDAL);
    }

    public static void registerStance(Class<? extends EntityLivingBase> entity, Stance stance) {
        STANCES.put(entity, stance);
    }

    public static Stance getStance(EntityLivingBase entity) {
        Stance registeredStance = STANCES.get(entity.getClass());
        if (registeredStance != null) {
            return registeredStance;
        }
        return EntityUtil.guessStance(entity);
    }

    private static Stance guessStance(EntityLivingBase entity) {
        if (entity instanceof EntityAnimal) {
            return Stance.QUADRUPEDAL;
        }
        if (entity instanceof EntityMob) {
            return Stance.BIPEDAL;
        }
        float height = Math.max(entity.field_70131_O, entity.func_70047_e());
        return height > entity.field_70130_N ? Stance.BIPEDAL : Stance.QUADRUPEDAL;
    }

    public static boolean isCoveredBy(EntityLivingBase entity, ItemArmor.ArmorMaterial material) {
        for (ItemStack armorStack : entity.func_184193_aE()) {
            if (armorStack.func_190926_b()) {
                return false;
            }
            Item armorItem = armorStack.func_77973_b();
            if (!(armorItem instanceof ItemArmor) || material == ((ItemArmor)armorItem).func_82812_d()) continue;
            return false;
        }
        return true;
    }

    public static enum Stance {
        BIPEDAL,
        QUADRUPEDAL,
        NONE;

    }
}

