/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.network;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageAnimation
implements IMessage {
    private int entityId;
    private int duration;
    private AnimationCapability.AnimationType animationType;

    public MessageAnimation() {
    }

    public MessageAnimation(Entity entity, AnimationCapability.AnimationType animationType, int duration) {
        this.entityId = entity.func_145782_y();
        this.animationType = animationType;
        this.duration = duration;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.animationType = AnimationCapability.AnimationType.values()[buf.readInt()];
        this.duration = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.animationType.ordinal());
        buf.writeInt(this.duration);
    }

    public static class Handler
    implements IMessageHandler<MessageAnimation, IMessage> {
        public IMessage onMessage(MessageAnimation message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Midnight.proxy.handleMessage(ctx, player -> {
                    AnimationCapability animationCap;
                    Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                    if (entity != null && (animationCap = (AnimationCapability)entity.getCapability(Midnight.ANIMATION_CAP, null)) != null) {
                        animationCap.setAnimation(entity, message.animationType, message.duration);
                    }
                });
            }
            return null;
        }
    }
}

