/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InBiomeLootCondition
implements LootCondition {
    private final Biome requiredBiome;

    public InBiomeLootCondition(Biome requiredBiome) {
        this.requiredBiome = requiredBiome;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        if (context.func_186493_a() == null) {
            return false;
        }
        Biome biome = context.getWorld().func_180494_b(context.func_186493_a().func_180425_c());
        return biome == this.requiredBiome;
    }

    public static class Serialiser
    extends LootCondition.Serializer<InBiomeLootCondition> {
        public Serialiser() {
            super(new ResourceLocation("midnight", "in_biome"), InBiomeLootCondition.class);
        }

        public void serialize(JsonObject json, InBiomeLootCondition value, JsonSerializationContext context) {
            json.addProperty("biome", value.requiredBiome.getRegistryName().toString());
        }

        public InBiomeLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("biome")) {
                throw new JsonSyntaxException("Missing biome tag, expected to find a biome registry name");
            }
            ResourceLocation biomeResLoc = new ResourceLocation(json.get("biome").getAsString());
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeResLoc);
            if (biome == null) {
                throw new JsonSyntaxException("Invalid biome tag. " + biomeResLoc + " does not exist in the biome registry.");
            }
            return new InBiomeLootCondition(biome);
        }
    }
}

