/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.common.entity.EntityRift;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RiftEntityReference {
    private UUID entityId;
    private int dimension;
    private WeakReference<EntityRift> rift;

    public void set(EntityRift rift) {
        this.rift = new WeakReference<EntityRift>(rift);
        this.entityId = rift.func_110124_au();
        this.dimension = rift.field_70170_p.field_73011_w.getDimension();
    }

    @Nullable
    public EntityRift compute() {
        Optional<Entity> entity;
        EntityRift cached = this.get();
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world != null && cached == null && (entity = world.field_72996_f.stream().filter(e -> e instanceof EntityRift).filter(e -> e.func_110124_au().equals(this.entityId)).findFirst()).isPresent()) {
            EntityRift rift = (EntityRift)entity.get();
            this.rift = new WeakReference<EntityRift>(rift);
            return rift;
        }
        return cached;
    }

    @Nullable
    public EntityRift get() {
        EntityRift rift;
        EntityRift entityRift = rift = this.rift != null ? (EntityRift)((Object)this.rift.get()) : null;
        if (rift != null && this.isInvalid(rift)) {
            this.rift = null;
            return null;
        }
        return rift;
    }

    private boolean isInvalid(EntityRift rift) {
        if (!rift.field_70170_p.field_72995_K) {
            return DimensionManager.getWorld((int)rift.field_70170_p.field_73011_w.getDimension()) == null;
        }
        return false;
    }

    public boolean hasReference() {
        return this.entityId != null;
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        if (this.entityId != null) {
            compound.func_186854_a("id", this.entityId);
            compound.func_74768_a("dimension", this.dimension);
        }
        return compound;
    }

    public void deserialize(NBTTagCompound compound) {
        if (compound.func_74764_b("idLeast")) {
            this.entityId = compound.func_186857_a("id");
            this.dimension = compound.func_74762_e("dimension");
        }
    }
}

