/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.creature.EntityGrowable;
import com.mushroom.midnight.common.entity.navigation.CustomPathNavigateGround;
import com.mushroom.midnight.common.entity.task.EntityTaskNeutral;
import com.mushroom.midnight.common.registry.ModLootTables;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityStinger
extends EntityGrowable
implements IMob {
    private final AnimationCapability animCap = new AnimationCapability();

    public EntityStinger(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.2f, 0.2f);
    }

    @Override
    public int getMaxGrowingAge() {
        return 5;
    }

    @Override
    public int getGrowingTimeByAge() {
        return 1200;
    }

    @Override
    protected void onGrowingToAge(int age) {
        float maxHealth = 10.0f + (float)age * 4.0f;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        this.func_70606_j(maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 + (double)age);
        if (age > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)age);
        }
        if (age == this.getMaxGrowingAge()) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]), false));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true, false), false));
        }
    }

    @Override
    @Nullable
    public EntityGrowable createChild(EntityGrowable growable) {
        return null;
    }

    protected PathNavigate func_175447_b(World world) {
        return new CustomPathNavigateGround((EntityLiving)this, world);
    }

    public boolean func_70601_bi() {
        if (this.func_180425_c().func_177956_o() > 50) {
            return false;
        }
        IBlockState belowState = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return belowState.func_185917_h() && belowState.func_189884_a((Entity)this);
    }

    protected boolean func_70692_ba() {
        return !this.func_70631_g_();
    }

    public boolean func_70617_f_() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    public int func_70627_aG() {
        return 100;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2), true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.7, 0.005f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]), false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityTaskNeutral(this, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true, true), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (flag) {
            if (!this.func_70631_g_()) {
                int age = this.getGrowingAge();
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, age == this.getMaxGrowingAge() ? 2 : (age > 2 ? 1 : 0), false, true));
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            this.animCap.setAnimation((Entity)this, AnimationCapability.AnimationType.ATTACK, 10);
        }
        return flag;
    }

    public void func_184609_a(EnumHand hand) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_STINGER;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.setGrowingAge(-1);
        }
        return livingdata;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 5 + this.getGrowingAge() * 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.animCap.updateAnimation();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.ANIMATION_CAP) {
            return (T)Midnight.ANIMATION_CAP.cast((Object)this.animCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.ANIMATION_CAP || super.hasCapability(capability, facing);
    }
}

