/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModLootTables;
import com.mushroom.midnight.common.registry.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrystalBug
extends EntityAmbientCreature {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityCrystalBug.class, (DataSerializer)DataSerializers.field_187198_h);
    private BlockPos spawnPosition;

    public EntityCrystalBug(World world) {
        super(world);
        this.func_70105_a(0.2f, 0.2f);
        this.field_70728_aV = 3;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean func_70601_bi() {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 10;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setStanding(boolean isStanding) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)isStanding);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isStanding()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else {
            this.field_70181_x *= 0.4;
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)compound.func_74767_n("isStanding"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isStanding", ((Boolean)this.field_70180_af.func_187225_a(IS_STANDING)).booleanValue());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isStanding()) {
            this.setStanding(false);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177972_a(this.func_174811_aO());
        if (this.isStanding()) {
            if (this.canStayOnBlock(this.field_70170_p.func_180495_p(blockpos1))) {
                if (this.field_70170_p.func_184136_b((Entity)this, 4.0) != null) {
                    this.setStanding(false);
                    this.field_70170_p.func_180498_a(null, 1025, blockpos, 0);
                }
            } else {
                this.setStanding(false);
                this.field_70170_p.func_180498_a(null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(d0) * 0.2 - this.field_70159_w) * 0.1;
            this.field_70181_x += (Math.signum(d1) * 0.4 - this.field_70181_x) * 0.1;
            this.field_70179_y += (Math.signum(d2) * 0.2 - this.field_70179_y) * 0.1;
            float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.2f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.canStayOnBlock(this.field_70170_p.func_180495_p(blockpos1))) {
                this.setStanding(true);
                this.spawnPosition = blockpos1;
            }
        }
        if (!this.isStanding() && this.field_70173_aa % 80 == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), ModSounds.CRYSTAL_BUG_FLYING, SoundCategory.NEUTRAL, this.func_70681_au().nextFloat() * 0.6f, this.func_70681_au().nextFloat() * 0.15f);
        }
    }

    private boolean canStayOnBlock(IBlockState state) {
        return state.func_177230_c() == ModBlocks.BLOOMCRYSTAL_ROCK;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O / 3.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.CRYSTAL_BUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.CRYSTAL_BUG_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.LOOT_TABLE_CRYSTAL_BUG;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xE000E0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }
}

