/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import java.util.Random;
import javax.vecmath.Point2f;
import net.minecraft.util.math.MathHelper;

public class RiftGeometry {
    private static final int POINT_COUNT = 12;
    private static final float DISPLACEMENT_SCALE = 0.4f;
    private final long seed;
    private final float width;
    private final float height;

    public RiftGeometry(long seed, float width, float height) {
        this.seed = seed;
        this.width = width;
        this.height = height;
    }

    public Point2f[] computePath(float animation, float unstableAnimation, float time) {
        Random random = new Random(this.seed);
        Point2f[] ring = new Point2f[12];
        float idleSpeed = 0.08f;
        float idleIntensity = 0.1f * animation * (unstableAnimation * 5.0f + 1.0f);
        float displacementAnimation = Math.min(2.0f * animation, 1.0f);
        float sizeX = this.width / 2.0f * animation;
        float sizeY = this.height / 2.0f * 0.5f * (animation + 1.0f);
        float tau = (float)Math.PI * 2;
        for (int i = 0; i < 12; ++i) {
            float angle = (float)i * tau / 12.0f;
            float idleAnimation = MathHelper.func_76126_a((float)(time * idleSpeed + (float)(i * 10))) * idleIntensity;
            float displacement = random.nextFloat() * 2.0f - 1.0f + idleAnimation;
            float scaledDisplacement = displacement * 0.4f * displacementAnimation;
            float pointX = -MathHelper.func_76126_a((float)angle) * (sizeX + scaledDisplacement);
            float pointY = MathHelper.func_76134_b((float)angle) * (sizeY + scaledDisplacement);
            ring[i] = new Point2f(pointX, pointY);
        }
        return ring;
    }

    public long getSeed() {
        return this.seed;
    }
}

