/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import com.mushroom.midnight.common.entity.EntityRift;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RiftAttachment {
    private final BlockPos pos;
    private final float yaw;

    public RiftAttachment(BlockPos pos, float yaw) {
        this.pos = pos;
        this.yaw = yaw;
    }

    public static RiftAttachment read(ByteBuf buf) {
        BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
        float yaw = buf.readFloat();
        return new RiftAttachment(pos, yaw);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void write(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeFloat(this.yaw);
    }

    public RiftAttachment fixedToSurface(World world) {
        BlockPos surfacePos = new BlockPos(this.pos.func_177958_n(), world.func_175726_f(this.pos).func_177433_f(this.pos), this.pos.func_177952_p());
        return new RiftAttachment(surfacePos, this.yaw);
    }

    public void apply(EntityRift rift) {
        rift.func_70080_a((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, this.yaw, 0.0f);
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        compound.func_74768_a("x", this.pos.func_177958_n());
        compound.func_74768_a("y", this.pos.func_177956_o());
        compound.func_74768_a("z", this.pos.func_177952_p());
        compound.func_74776_a("yaw", this.yaw);
        return compound;
    }

    public static RiftAttachment deserialize(NBTTagCompound compound) {
        BlockPos pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        float yaw = compound.func_74760_g("yaw");
        return new RiftAttachment(pos, yaw);
    }
}

