/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.capability;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.registry.ModCavernousBiomes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.registries.ForgeRegistry;

public class CavernousBiomeStore
implements ICapabilitySerializable<NBTTagCompound> {
    private final CavernousBiome[] biomes = new CavernousBiome[256];

    public static CavernousBiome getBiome(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        CavernousBiomeStore biomeStore = (CavernousBiomeStore)chunk.getCapability(Midnight.CAVERNOUS_BIOME_CAP, null);
        if (biomeStore != null) {
            return biomeStore.getBiome(x & 0xF, z & 0xF);
        }
        return ModCavernousBiomes.CLOSED_CAVERN;
    }

    public void populate(CavernousBiome[] biomes) {
        System.arraycopy(biomes, 0, this.biomes, 0, biomes.length);
    }

    @Nonnull
    public CavernousBiome getBiome(int x, int z) {
        CavernousBiome biome = this.biomes[(x & 0xF) + (z & 0xF) * 16];
        if (biome == null) {
            return ModCavernousBiomes.CLOSED_CAVERN;
        }
        return biome;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        byte[] bytes = new byte[this.biomes.length];
        for (int i = 0; i < this.biomes.length; ++i) {
            CavernousBiome biome = this.biomes[i];
            if (biome == null) continue;
            bytes[i] = (byte)(ModCavernousBiomes.getId(biome) & 0xFF);
        }
        compound.func_74773_a("biomes", bytes);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        ForgeRegistry<CavernousBiome> registry = ModCavernousBiomes.getRegistry();
        byte[] bytes = compound.func_74770_j("biomes");
        for (int i = 0; i < bytes.length; ++i) {
            this.biomes[i] = (CavernousBiome)registry.getValue(bytes[i] & 0xFF);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Midnight.CAVERNOUS_BIOME_CAP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Midnight.CAVERNOUS_BIOME_CAP) {
            return (T)Midnight.CAVERNOUS_BIOME_CAP.cast((Object)this);
        }
        return null;
    }
}

