/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModCriterion;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSuavis
extends Block
implements IModelProvider,
IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)3);
    protected static final AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSuavis() {
        super(Material.field_151572_C, MapColor.field_151674_s);
        this.func_149715_a(0.8f);
        this.func_149647_a(ModTabs.DECORATION_TAB);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)));
        this.func_149675_a(true);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (!world.field_72995_K && fallDistance > 0.8f && entity instanceof EntityLivingBase) {
            boolean isFirstStage;
            IBlockState state = world.func_180495_p(pos);
            world.func_184133_a(null, pos, SoundEvents.field_187872_fl, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
            boolean bl = isFirstStage = (Integer)state.func_177229_b((IProperty)STAGE) == 0;
            if (!isFirstStage && world.field_73012_v.nextInt(100) == 0) {
                world.func_175655_b(pos, true);
            } else {
                BlockSuavis.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.RAW_SUAVIS));
                world.func_180501_a(pos, isFirstStage ? Blocks.field_150350_a.func_176223_P() : state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STAGE) - 1)), 2);
                world.func_175718_b(2001, pos, BlockSuavis.func_176210_f((IBlockState)state));
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_()) {
                    BlockSuavis.createNauseaCloud(world, pos, 0);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.RAW_SUAVIS;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModItems.RAW_SUAVIS);
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) == 3;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN || (Integer)state.func_177229_b((IProperty)STAGE) == 3 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public boolean func_149662_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) == 3;
    }

    public boolean func_149700_E() {
        return true;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        this.harvesters.set(player);
        this.func_176226_b(world, pos, state, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
        this.harvesters.set(null);
        if (!world.field_72995_K && !player.func_184812_l_() && player instanceof EntityPlayerMP) {
            ModCriterion.HARVESTED_SUAVIS.trigger((EntityPlayerMP)player);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        EntityPlayer player;
        super.func_180653_a(world, pos, state, chance, fortune);
        if (!world.field_72995_K && ((player = (EntityPlayer)this.harvesters.get()) == null || !player.func_184812_l_() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0)) {
            BlockSuavis.createNauseaCloud(world, pos, (Integer)state.func_177229_b((IProperty)STAGE));
        }
    }

    private static void createNauseaCloud(World world, BlockPos pos, int intensity) {
        EntityAreaEffectCloud entity = new EntityAreaEffectCloud(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        entity.func_184483_a(1.5f + 0.5f * (float)intensity);
        entity.func_184495_b(-0.3f);
        entity.func_184485_d(10);
        entity.func_184487_c(-entity.func_184490_j() / (float)entity.func_184489_o());
        entity.func_184484_a(PotionTypes.field_185229_a);
        entity.func_184482_a(3495830);
        entity.func_184496_a(new PotionEffect(MobEffects.field_76431_k, 20 * (intensity + 1) * 6, 0, false, true));
        world.func_72838_d((Entity)entity);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        boolean isSilkTouch = this.harvesters.get() != null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)((EntityPlayer)this.harvesters.get()).func_184614_ca()) > 0;
        int stage = (Integer)state.func_177229_b((IProperty)STAGE);
        if (isSilkTouch && stage == 3) {
            drops.add((Object)new ItemStack((Block)this));
            return;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = isSilkTouch ? stage + 1 : this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int skyLight = 15;
        int blockLight = 15;
        return skyLight << 20 | blockLight << 4;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)STAGE) < 3;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STAGE) + 1)), 2);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.isSideSolid(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos, EnumFacing.UP)) {
            world.func_175655_b(pos, true);
        } else if ((Integer)state.func_177229_b((IProperty)STAGE) < 3 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            this.func_176474_b(world, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
        }
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int maxSlice = (Integer)state.func_177229_b((IProperty)STAGE) + 1;
        int minSlice = Math.min(1 + fortune, maxSlice);
        return random.nextInt(maxSlice - minSlice + 1) + minSlice;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return bounds[(Integer)state.func_177229_b((IProperty)STAGE)];
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)STAGE) < 2;
    }
}

