/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public abstract class BlockMixableFluid
extends BlockFluidClassic {
    public BlockMixableFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Nullable
    protected abstract IBlockState getMixState(IBlockState var1);

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (this.tryMix(world, pos)) {
            return;
        }
        super.flowIntoBlock(world, pos, meta);
        this.tryMix(world, pos.func_177977_b());
    }

    protected boolean tryMix(World world, BlockPos pos) {
        IBlockState currentState = world.func_180495_p(pos);
        IBlockState mixState = this.getMixState(currentState);
        if (mixState != null) {
            world.func_175656_a(pos, mixState);
            this.spawnMixEffects(world, pos, currentState);
            return true;
        }
        return false;
    }

    protected void spawnMixEffects(World world, BlockPos pos, IBlockState currentState) {
        SoundEvent mixSound = this.getMixSound(currentState);
        float pitch = 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f;
        world.func_184133_a(null, pos, mixSound, SoundCategory.BLOCKS, 0.5f, pitch);
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        for (int i = 0; i < 8; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x + Math.random(), y + 1.2, z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected SoundEvent getMixSound(IBlockState state) {
        return SoundEvents.field_187659_cY;
    }
}

