/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModTabs;
import com.mushroom.midnight.common.tile.base.TileEntityMidnightChest;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;

public class BlockMidnightChest
extends BlockChest
implements IModelProvider {
    private final ChestModel chestModel;

    public BlockMidnightChest(ChestModel chestModel) {
        super(BlockChest.Type.BASIC);
        this.chestModel = chestModel;
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(ModTabs.DECORATION_TAB);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMidnightChest(this.chestModel);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!blockState.func_185897_m()) {
            return 0;
        }
        int i = 0;
        TileEntity tileentity = blockAccess.func_175625_s(pos);
        if (tileentity instanceof TileEntityMidnightChest) {
            i = ((TileEntityMidnightChest)tileentity).numPlayersUsing;
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)15);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        boolean flag3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing);
        BlockPos blockpos = pos.func_177978_c();
        BlockPos blockpos1 = pos.func_177968_d();
        BlockPos blockpos2 = pos.func_177976_e();
        BlockPos blockpos3 = pos.func_177974_f();
        boolean flag = this == worldIn.func_180495_p(blockpos).func_177230_c();
        boolean flag1 = this == worldIn.func_180495_p(blockpos1).func_177230_c();
        boolean flag2 = this == worldIn.func_180495_p(blockpos2).func_177230_c();
        boolean bl = flag3 = this == worldIn.func_180495_p(blockpos3).func_177230_c();
        if (!(flag || flag1 || flag2 || flag3)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() != EnumFacing.Axis.X || !flag && !flag1) {
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flag2 || flag3)) {
                if (flag2) {
                    worldIn.func_180501_a(blockpos2, state, 3);
                } else {
                    worldIn.func_180501_a(blockpos3, state, 3);
                }
                worldIn.func_180501_a(pos, state, 3);
            }
        } else {
            if (flag) {
                worldIn.func_180501_a(blockpos, state, 3);
            } else {
                worldIn.func_180501_a(blockpos1, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMidnightChest) {
            ((TileEntityMidnightChest)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMidnightChest) {
            tileentity.func_145836_u();
        }
    }

    @Nullable
    public ILockableContainer func_189418_a(World worldIn, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityMidnightChest)) {
            return null;
        }
        TileEntityMidnightChest ilockablecontainer = (TileEntityMidnightChest)tileentity;
        if (!allowBlocking && this.isBlocked(worldIn, pos)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = worldIn.func_180495_p(blockpos).func_177230_c();
            if (block != this) continue;
            if (!allowBlocking && this.isBlocked(worldIn, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityMidnightChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest("tile.midnight." + this.chestModel.getName() + "_double_chest.name", (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityMidnightChest)tileentity1));
                continue;
            }
            ilockablecontainer = new InventoryLargeChest("tile.midnight." + this.chestModel.getName() + "_double_chest.name", (ILockableContainer)((TileEntityMidnightChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static enum ChestModel {
        SHADOWROOT("shadowroot");

        private String name;

        private ChestModel(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ChestModel getDefault() {
            return SHADOWROOT;
        }
    }
}

