/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.cavern;

import com.mushroom.midnight.common.biome.EntitySpawnConfigured;
import com.mushroom.midnight.common.biome.MidnightBiomeDecorator;
import com.mushroom.midnight.common.biome.cavern.CavernousBiomeConfig;
import com.mushroom.midnight.common.biome.config.SpawnerConfig;
import com.mushroom.midnight.common.biome.config.SurfaceConfig;
import com.mushroom.midnight.common.world.SurfaceCoverGenerator;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CavernousBiome
extends IForgeRegistryEntry.Impl<CavernousBiome>
implements EntitySpawnConfigured {
    private final CavernousBiomeConfig config;
    private final MidnightBiomeDecorator decorator;
    private final SurfaceCoverGenerator coverGenerator = new SurfaceCoverGenerator(1, Integer.MAX_VALUE).withMaxY(58);

    public CavernousBiome(CavernousBiomeConfig config) {
        this.config = config;
        this.decorator = this.config.getFeatureConfig().createDecorator(PlacementLevel.INSTANCE);
    }

    public void decorate(World world, Random random, BlockPos pos) {
        this.decorator.func_180292_a(world, random, Biomes.field_180279_ad, pos);
    }

    public void coverSurface(Random random, ChunkPrimer primer, int x, int z, double noiseVal) {
        SurfaceConfig config = this.config.getSurfaceConfig();
        if (config == null) {
            return;
        }
        int fillerDepth = (int)(noiseVal / 3.0 + 3.0 + random.nextDouble() * 0.25);
        this.coverGenerator.coverSurface(config, primer, x, z, fillerDepth);
    }

    public CavernousBiomeConfig getConfig() {
        return this.config;
    }

    @Override
    public SpawnerConfig getSpawnerConfig() {
        return this.config.getSpawnerConfig();
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
        Biome.FlowerEntry flower;
        if (!(this.config.getFeatureConfig().getFlowers().isEmpty() || (flower = (Biome.FlowerEntry)WeightedRandom.func_76271_a((Random)rand, this.config.getFeatureConfig().getFlowers())) == null || flower.state == null || flower.state.func_177230_c() instanceof BlockBush && !((BlockBush)flower.state.func_177230_c()).func_180671_f(world, pos, flower.state))) {
            world.func_180501_a(pos, flower.state, 3);
        }
    }

    public static class PlacementLevel
    implements SurfacePlacementLevel {
        public static final SurfacePlacementLevel INSTANCE = new PlacementLevel();

        private PlacementLevel() {
        }

        @Override
        public BlockPos getSurfacePos(World world, BlockPos pos) {
            Chunk chunk = world.func_175726_f(pos);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int y = 5; y < 58; ++y) {
                mutablePos.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p());
                IBlockState state = chunk.func_177435_g((BlockPos)mutablePos);
                if (state.func_185904_a() != Material.field_151579_a) continue;
                return mutablePos.func_185334_h();
            }
            return pos;
        }

        @Override
        public int generateUpTo(World world, Random random, int y) {
            return random.nextInt(Math.min(y, 58));
        }
    }
}

