/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client;

import com.mushroom.midnight.client.sound.MidnightCaveSound;
import com.mushroom.midnight.client.sound.MidnightIdleSound;
import com.mushroom.midnight.common.entity.util.ToggleAnimation;
import com.mushroom.midnight.common.helper.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="midnight", value={Side.CLIENT})
public class IdleSoundController {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final ISound IDLE_SOUND = new MidnightIdleSound();
    private static final ISound CAVE_IDLE_SOUND = new MidnightCaveSound();
    public static final ToggleAnimation CAVE_ANIMATION = new ToggleAnimation(20);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!MC.func_147113_T()) {
            EntityPlayerSP player = IdleSoundController.MC.field_71439_g;
            if (player == null || event.phase == TickEvent.Phase.START) {
                return;
            }
            if (Helper.isMidnightDimension(player.field_70170_p)) {
                CAVE_ANIMATION.set(player.field_70163_u < 62.0 && !player.field_70170_p.func_175678_i(player.func_180425_c()));
                CAVE_ANIMATION.update();
                IdleSoundController.retainIdleSound(IDLE_SOUND);
                IdleSoundController.retainIdleSound(CAVE_IDLE_SOUND);
            }
        }
    }

    private static void retainIdleSound(ISound sound) {
        SoundHandler soundHandler = MC.func_147118_V();
        if (!soundHandler.func_147692_c(sound)) {
            try {
                soundHandler.func_147683_b(sound);
                soundHandler.func_147682_a(sound);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

