/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.particles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ParticleHandler {
    public static boolean depthEnabled = true;
    public static int range = 32;
    private static final List<Particle> PARTICLES = new ArrayList<Particle>();
    private static final List<Particle> PARTICLES_NO_DEPTH = new ArrayList<Particle>();

    public static void spawnParticle(Supplier<Particle> particle, double x, double y, double z) {
        if (Minecraft.func_71410_x().field_71439_g.func_70092_e(x, y, z) <= (double)(range * range)) {
            int setting;
            Minecraft mc = Minecraft.func_71410_x();
            if (!(!ModConfig.client.respectVanillaParticleSettings || (setting = mc.field_71474_y.field_74362_aa) == 0 || setting == 1 && mc.field_71441_e.field_73012_v.nextInt(3) == 0 || setting == 2 && mc.field_71441_e.field_73012_v.nextInt(10) == 0)) {
                return;
            }
            double setting2 = ModConfig.client.particleAmount;
            if (setting2 < 1.0 && mc.field_71441_e.field_73012_v.nextDouble() > setting2) {
                return;
            }
            if (depthEnabled) {
                PARTICLES.add(particle.get());
            } else {
                PARTICLES_NO_DEPTH.add(particle.get());
            }
        }
    }

    public static void updateParticles() {
        ParticleHandler.updateList(PARTICLES);
        ParticleHandler.updateList(PARTICLES_NO_DEPTH);
        depthEnabled = true;
        range = 32;
    }

    private static void updateList(List<Particle> particles) {
        for (int i = particles.size() - 1; i >= 0; --i) {
            Particle particle = particles.get(i);
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            particles.remove(i);
        }
    }

    public static void renderParticles(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null) {
            float x = ActiveRenderInfo.func_178808_b();
            float z = ActiveRenderInfo.func_178803_d();
            float yz = ActiveRenderInfo.func_178805_e();
            float xy = ActiveRenderInfo.func_178807_f();
            float xz = ActiveRenderInfo.func_178809_c();
            Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            Particle.field_190016_K = player.func_70676_i(partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179129_p();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179132_a((boolean)false);
            mc.func_110434_K().func_110577_a(ParticleMagic.TEXTURE);
            Tessellator tessy = Tessellator.func_178181_a();
            BufferBuilder buffer = tessy.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, x, xz, z, yz, xy);
            }
            tessy.func_78381_a();
            GlStateManager.func_179097_i();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES_NO_DEPTH) {
                particle.func_180434_a(buffer, (Entity)player, partialTicks, x, xz, z, yz, xy);
            }
            tessy.func_78381_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
        }
    }

    public static int getParticleAmount(boolean depth) {
        return depth ? PARTICLES.size() : PARTICLES_NO_DEPTH.size();
    }

    public static void clearParticles() {
        if (!PARTICLES.isEmpty()) {
            PARTICLES.clear();
        }
        if (!PARTICLES_NO_DEPTH.isEmpty()) {
            PARTICLES_NO_DEPTH.clear();
        }
    }
}

