/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunkProvider;
import de.ellpeck.naturesaura.misc.WorldData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommonEvents {
    @SubscribeEvent
    public void onChunkCapsAttach(AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        event.addCapability(new ResourceLocation("naturesaura", "aura"), (ICapabilityProvider)new AuraChunkProvider(chunk));
    }

    @SubscribeEvent
    public void onWorldCapsAttach(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("naturesaura", "data"), (ICapabilityProvider)new WorldData());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 20L == 0L) {
            event.world.field_72984_F.func_194340_a(() -> "naturesaura:onWorldTick");
            Iterator chunks = event.world.getPersistentChunkIterable(((WorldServer)event.world).func_184164_w().func_187300_b());
            while (chunks.hasNext()) {
                Chunk chunk = (Chunk)chunks.next();
                if (!chunk.hasCapability(NaturesAuraAPI.capAuraChunk, null)) continue;
                AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null);
                auraChunk.update();
            }
            event.world.field_72984_F.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.func_82737_E() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea(event.player.field_70170_p, event.player.func_180425_c(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        if (!chunk.func_177412_p().field_72995_K && chunk.hasCapability(NaturesAuraAPI.capAuraChunk, null)) {
            AuraChunk auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null);
            PacketHandler.sendTo((EntityPlayer)event.getPlayer(), auraChunk.makePacket());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("naturesaura".equals(event.getModID())) {
            ConfigManager.sync((String)"naturesaura", (Config.Type)Config.Type.INSTANCE);
            ModConfig.initOrReload(true);
        }
    }
}

