/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PlantBoostEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "plant_boost");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(world, pos, 30);
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(45, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 100000.0f / (float)IAuraChunk.getSpotAmountInArea(world, pos, 30))));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        return true;
    }

    @Override
    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (player.func_174818_b(pos) > (double)(this.dist * this.dist)) {
            return -1;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_180425_c(), NAME)) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack(Items.field_151014_N);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            IGrowable growable;
            IBlockState state;
            Block block;
            int z;
            int x = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist));
            BlockPos plantPos = new BlockPos(x, world.func_189649_b(x, z = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist))), z);
            if (!(plantPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(plantPos) || NaturesAuraAPI.instance().isEffectPowderActive(world, plantPos, NAME) || !((block = (state = world.func_180495_p(plantPos)).func_177230_c()) instanceof IGrowable) || block == Blocks.field_150329_H || block == Blocks.field_150349_c || block == Blocks.field_150398_cm || !(growable = (IGrowable)block).func_176473_a(world, plantPos, state, false)) continue;
            growable.func_176474_b(world, world.field_73012_v, plantPos, state);
            BlockPos closestSpot = IAuraChunk.getHighestSpot(world, plantPos, 25, pos);
            IAuraChunk.getAuraChunk(world, closestSpot).drainAura(closestSpot, 3500);
            PacketHandler.sendToAllAround(world, plantPos, 32, new PacketParticles(plantPos.func_177958_n(), plantPos.func_177956_o(), plantPos.func_177952_p(), 6, new int[0]));
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.plantBoostEffect && type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

